//BATMAN! - Yeah - well not all of his powers or it'd be unfair...

/* CVARS - copy and paste to shconfig.cfg

//Batman
batman_level 0
batman_health 125		//default 125
batman_armor 125		//defualt 125

*/

/*
* v1.17 - JTP10181 - 07/23/04
*       - Fixed issue where you could get zoomed in on other primaries if combined with punisher
*
* 5/17 - Took out ammo give to test for a bug
*        + Punisher gets unlimited ammo - so this is desired not to make
*        batman so powerful.  Batman is split between Batman and Punisher
*/

#include <amxmod>
#include <Vexd_Utilities>
#include <superheromod>

// GLOBAL VARIABLES
new gHeroName[]="Batman"
new bool:gHasBatPower[SH_MAXSLOTS+1]
new gCurrentWeapon[SH_MAXSLOTS+1]
new gmsgSetFOV

#define giveTotal 8
new weapArray[giveTotal][24] = {
	"weapon_flashbang",
	"weapon_smokegrenade",
	"weapon_deagle",
	"weapon_mp5navy",
	"weapon_xm1014",
	"weapon_sg552",
	"weapon_awp",
	"weapon_m4a1"
}

//----------------------------------------------------------------------------------------------
public plugin_init()
{
	// Plugin Info
	register_plugin("SUPERHERO Batman","1.18","{HOJ} Batman/JTP10181")

	// DO NOT EDIT THIS FILE TO CHANGE CVARS, USE THE SHCONFIG.CFG
	register_cvar("batman_level", "0")
	register_cvar("batman_health", "125")
	register_cvar("batman_armor", "125")

	// FIRE THE EVENT TO CREATE THIS SUPERHERO!
	shCreateHero(gHeroName, "Utility Belt", "Extra Weapons and Health - Buy the Ammo or Use with Punisher", false, "batman_level" )

	// REGISTER EVENTS THIS HERO WILL RESPOND TO! (AND SERVER COMMANDS)
	register_srvcmd("batman_init", "batman_init")
	shRegHeroInit(gHeroName, "batman_init")
	register_event("ResetHUD","newRound","b")
	register_event("CurWeapon","changeWeapon","be","1=1")

	// Let Server know about BATMANs Variable
	// It is possible that another hero has more hps, less gravity, or more armor
	// so rather than just setting these - let the superhero module decide each round
	shSetMaxHealth(gHeroName, "batman_health" )
	shSetMaxArmor(gHeroName, "batman_armor" )
	shSetShieldRestrict(gHeroName)

	gmsgSetFOV = get_user_msgid("SetFOV")
}
//----------------------------------------------------------------------------------------------
public batman_init()
{
	// First Argument is an id
	new temp[6]
	read_argv(1,temp,5)
	new id = str_to_num(temp)

	// 2nd Argument is 0 or 1 depending on whether the id has batman
	read_argv(2,temp,5)
	new hasPowers = str_to_num(temp)

	if (!is_user_connected(id)) return

	//Reset thier shield restrict status
	//Shield restrict MUST be before weapons are given out
	shResetShield(id)

	if ( hasPowers ) {
		batman_giveweapons(id)
	}
	//This gets run if they had the power but don't anymore
	else if ( gHasBatPower[id] ) {
		shRemHealthPower(id)
		shRemArmorPower(id)
		batman_dropweapons(id)
	}

	//Sets this variable to the current status
	gHasBatPower[id] = (hasPowers != 0)
}
//----------------------------------------------------------------------------------------------
public newRound(id)
{
	if ( gHasBatPower[id] && is_user_alive(id) && shModActive() ) {
		set_task(0.1, "batman_giveweapons",id)
	}
}
//----------------------------------------------------------------------------------------------
public batman_giveweapons(id)
{
	if ( !is_user_alive(id) ) return

	for (new x = 0; x < giveTotal; x++) {
		shGiveWeapon(id, weapArray[x])
	}

	// Give CTs a Defuse Kit
	if ( get_user_team(id) == 2 ) shGiveWeapon(id,"item_thighpack")
}
//----------------------------------------------------------------------------------------------
public batman_dropweapons(id)
{
	if ( !is_user_alive(id) ) return

	for (new x = 0; x < giveTotal; x++) {
		engclient_cmd(id,"drop", weapArray[x])
	}

	new iCurrent = -1
	new Float:weapvel[3]

	while ( (iCurrent = FindEntity(iCurrent, "weaponbox")) > 0 ) {

		//Skip anything not owned by this client
		if ( Entvars_Get_Edict(iCurrent, EV_ENT_owner) != id) continue

		//Get Weapon velocites
		Entvars_Get_Vector(iCurrent, EV_VEC_velocity, weapvel)

		//If Velocities are all Zero its on the ground already and should stay there
		if (weapvel[0] == 0.0 && weapvel[1] == 0.0 && weapvel[2] == 0.0) continue

		RemoveEntity(iCurrent)
	}
}
//----------------------------------------------------------------------------------------------
public changeWeapon(id)
{
	if ( !shModActive() || !gHasBatPower[id] ) return

	new weaponid = read_data(2)

	if ( gCurrentWeapon[id] != weaponid ) {
		gCurrentWeapon[id] = weaponid
		batman_zoomout(id)
	}
}
//----------------------------------------------------------------------------------------------
public client_connect(id)
{
	gHasBatPower[id] = false
}
//----------------------------------------------------------------------------------------------
public batman_zoomout(id)
{
	if ( !is_user_connected(id) || !is_user_alive(id)) return
	message_begin(MSG_ONE, gmsgSetFOV, {0,0,0}, id)
	write_byte(90) //not Zooming
	message_end()
}
