// WOLVERINE!

/* CVARS - copy and paste to shconfig.cfg

//Wolverine
wolv_level 0
wolv_healpoints 3			//The # of HP healed per second
wolv_knifespeed 290			//Speed of wolveine in knife mode
wolv_knifemult 1.35			//Multiplier for knife damage

*/

// v1.17 - JTP - fixed runtime error on damage event if user is already dead
// v1.17.5 - JTP - Added code to allow you to regen to your max heatlh

#include <amxmod>
#include <superheromod>

// GLOBAL VARIABLES
new gHeroName[]="Wolverine"
new bool:ghasWolvPowers[SH_MAXSLOTS+1]
new gPlayerMaxHealth[SH_MAXSLOTS+1]
new gHealPoints
//----------------------------------------------------------------------------------------------
public plugin_init()
{
	// Plugin Info
	register_plugin("SUPERHERO Wolverine","1.18","{HOJ}Batman/JTP10181")

	// DO NOT EDIT THIS FILE TO CHANGE CVARS, USE THE SHCONFIG.CFG
	register_cvar("wolv_level", "0" )
	register_cvar("wolv_healpoints", "3" )
	register_cvar("wolv_knifespeed", "290")
	register_cvar("wolv_knifemult", "1.35" )

	// FIRE THE EVENT TO CREATE THIS SUPERHERO!
	shCreateHero(gHeroName, "Auto-Heal & Claws", "Auto-Heal, Extra Knife Damage and Speed Boost", false, "wolv_level" )

	// REGISTER EVENTS THIS HERO WILL RESPOND TO! (AND SERVER COMMANDS)
	register_srvcmd("wolv_init", "wolv_init")
	shRegHeroInit(gHeroName, "wolv_init")

	// HEAL LOOP
	set_task(1.0,"wolv_loop",0,"",0,"b" )

	// EXTRA KNIFE DAMAGE
	register_event("Damage", "wolv_damage", "b", "2!0")

	// Let Server know about Woverines max knife speed
	shSetMaxSpeed(gHeroName, "wolv_knifespeed", "[29]" )

	//Makes superhero tell wolverine a players max health
	register_srvcmd("wolv_maxhealth", "wolv_maxhealth")
	shRegMaxHealth(gHeroName, "wolv_maxhealth" )
	gHealPoints = get_cvar_num("wolv_healpoints")
}
//----------------------------------------------------------------------------------------------
public wolv_init()
{
	// First Argument is an id
	new temp[6]
	read_argv(1,temp,5)
	new id=str_to_num(temp)

	// 2nd Argument is 0 or 1 depending on whether the id has wolverine skills
	read_argv(2,temp,5)
	new hasPowers = str_to_num(temp)

	gPlayerMaxHealth[id] = 100
	ghasWolvPowers[id] = (hasPowers!=0)

	// Got to slow down a Wolverine that lost his powers...
	if ( !ghasWolvPowers[id]  && is_user_connected(id) ) {
		shRemSpeedPower(id)
	}
}
//----------------------------------------------------------------------------------------------
public wolv_loop()
{
	if (!shModActive()) return
	for ( new id = 1; id <= SH_MAXSLOTS; id++ ) {
		if (  ghasWolvPowers[id] && is_user_alive(id)  )   {
			// Let the server add the hps back since the # of max hps is controlled by it
			// I.E. Superman has more than 100 hps etc.
			shAddHPs(id, gHealPoints, gPlayerMaxHealth[id] )
		}
	}
}
//----------------------------------------------------------------------------------------------
public wolv_damage(id)
{
	if (!shModActive() || !is_user_alive(id)) return PLUGIN_CONTINUE

	new damage = read_data(2)
	new weapon, bodypart, attacker = get_user_attacker(id, weapon, bodypart)
	new headshot = bodypart == 1 ? 1 : 0

	if ( attacker <= 0 || attacker > SH_MAXSLOTS ) return PLUGIN_CONTINUE

	if ( ghasWolvPowers[attacker] && weapon == CSW_KNIFE && is_user_alive(id) ) {
		// do extra damage
		new extraDamage = floatround(damage * get_cvar_float("wolv_knifemult") - damage)
		if (extraDamage > 0) shExtraDamage( id, attacker, extraDamage, "knife", headshot )
	}
	return PLUGIN_CONTINUE
}
//----------------------------------------------------------------------------------------------
public wolv_maxhealth()
{
	new id[6]
	new health[9]

	read_argv(1,id,5)
	read_argv(2,health,8)

	gPlayerMaxHealth[str_to_num(id)] = str_to_num(health)
}
//----------------------------------------------------------------------------------------------