// AquaMan! - Made By AssKicR & Lazy <the_lazy_one_09@hotmail.com>
// Some sprite and code tweaks by JTP10181

/* CVARS - copy and paste to shconfig.cfg

//Aquaman
aquaman_level 0
aquaman_armorcost 0				//How much amour each bubble thrower blast uses
aquaman_numbubbles 7			//How many giant killer bubbles
aquaman_bubbledamage 10			//How much damage each bubble does

*/

#include <amxmod>
#include <Vexd_Utilities>
#include <superheromod>

// GLOBAL VARIABLES
new gHeroName[]="Aquaman"
new bool:gHasAquaPower[SH_MAXSLOTS+1]
new bool:gIsBubbling[SH_MAXSLOTS+1]
new gSpriteBubble
//----------------------------------------------------------------------------------------------
public plugin_init()
{
	// Plugin Info
	register_plugin("SUPERHERO Aquaman","1.18","AssKicR/Lazy/JTP10181")

	// DO NOT EDIT THIS FILE TO CHANGE CVARS, USE THE SHCONFIG.CFG
	register_cvar("aquaman_level", "0" )
	register_cvar("aquaman_armorcost", "0" )
	register_cvar("aquaman_numbubbles", "7" )
	register_cvar("aquaman_bubbledamage", "10" )

	// FIRE THE EVENT TO CREATE THIS SUPERHERO!
	shCreateHero(gHeroName, "Gills & Bubble Thrower", "You can Breathe Underwater and Fire your Bubble Thrower", true, "aquaman_level" )

	// REGISTER EVENTS THIS HERO WILL RESPOND TO! (AND SERVER COMMANDS)
	register_srvcmd("aquaman_init", "aquaman_init")
	shRegHeroInit(gHeroName, "aquaman_init")

	// KEYDOWN
	register_srvcmd("aquaman_kd", "aquaman_kd")
	shRegKeyDown(gHeroName, "aquaman_kd")

	set_task( 1.0, "UnderTheSea", 0, "", 0, "b" )

}
//----------------------------------------------------------------------------------------------
public plugin_precache()
{
	gSpriteBubble = precache_model("sprites/bubble.spr")
	precache_sound("scientist/scream1.wav")
	precache_sound("vox/_period.wav")
}
//----------------------------------------------------------------------------------------------
public aquaman_init()
{
	// First Argument is an id
	new temp[6]
	read_argv(1,temp,5)
	new id=str_to_num(temp)

	// 2nd Argument is 0 or 1 depending on whether the id has aquaman
	read_argv(2,temp,5)
	new hasPowers = str_to_num(temp)

	gHasAquaPower[id] = (hasPowers != 0)
}
//----------------------------------------------------------------------------------------------
public UnderTheSea()
{
	for( new i = 0; i < 33; i++ ) {
		if ( gHasAquaPower[i] && is_user_alive( i ) ) {
			if ( Entvars_Get_Int( i, EV_INT_waterlevel ) == 3 )  {
				Entvars_Set_Float( i, EV_FL_air_finished, Entvars_Get_Float( i, EV_FL_air_finished ) + 2.0 )
			}
		}
	}
}
//----------------------------------------------------------------------------------------------
// -|-LoA-|-Bass's Bubble thrower
public aquaman_kd()
{
	if ( !hasRoundStarted() ) return PLUGIN_HANDLED

	// First Argument is an id with aquaman
	new temp[6]
	read_argv(1,temp,5)
	new id = str_to_num(temp)

	if ( !is_user_alive(id) || !gHasAquaPower[id] ) return PLUGIN_HANDLED

	if ( Entvars_Get_Int( id, EV_INT_waterlevel ) != 3 ) {
		client_print(id,print_chat,"[SH] You must be underwater to use the Bubble Thrower")
		playSoundDenySelect(id)
		return PLUGIN_HANDLED
	}

	new fl_cost = get_cvar_num("aquaman_armorcost")
	new armr = get_user_armor(id)

	if (armr < fl_cost) {
		client_print(id,print_chat,"%s blasts cost %d armor points each", gHeroName, fl_cost)
		playSoundDenySelect(id)
		return PLUGIN_HANDLED
	}
	set_user_armor(id,armr - fl_cost)

	emit_sound(id, CHAN_WEAPON, "player/pl_swim3.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
	new vec[3]
	new aimvec[3]
	new velocityvec[3]
	new length
	new speed = 10
	get_user_origin(id,vec)
	get_user_origin(id,aimvec,2)
	new dist = get_distance(vec,aimvec)

	new speed1 = 160
	new speed2 = 350
	new radius = 105

	if (dist < 50)  {
		radius = 0
		speed = 5
	}
	else if (dist < 150) {
		speed1 = speed2 = 1
		speed = 5
		radius = 50
	}
	else if (dist < 200) {
		speed1 = speed2 = 1
		speed = 5
		radius = 90
	}
	else if (dist < 250) {
		speed1 = speed2 = 90
		speed = 6
		radius = 90
	}
	else if (dist < 300) {
		speed1 = speed2 = 140
		speed = 7
	}
	else if (dist < 350) {
		speed1 = speed2 = 190
		speed = 7
	}
	else if (dist < 400) {
		speed1 = 150
		speed2 = 240
		speed = 8
	}
	else if (dist < 450) {
		speed1 = 150
		speed2 = 290
		speed = 8
	}
	else if (dist < 500) {
		speed1 = 180
		speed2 = 340
		speed = 9
	}

	velocityvec[0]=aimvec[0]-vec[0]
	velocityvec[1]=aimvec[1]-vec[1]
	velocityvec[2]=aimvec[2]-vec[2]
	length=sqrt(velocityvec[0]*velocityvec[0]+velocityvec[1]*velocityvec[1]+velocityvec[2]*velocityvec[2])
	velocityvec[0]=velocityvec[0]*speed/length
	velocityvec[1]=velocityvec[1]*speed/length
	velocityvec[2]=velocityvec[2]*speed/length

	new args[8]
	args[0] = vec[0]
	args[1] = vec[1]
	args[2] = vec[2]
	args[3] = velocityvec[0]
	args[4] = velocityvec[1]
	args[5] = velocityvec[2]
	set_task(0.1,"te_spray",0,args,8,"a",2)
	check_bubblezone(id,vec,aimvec,speed1,speed2,radius)

	return PLUGIN_HANDLED
}
//----------------------------------------------------------------------------------------------
public te_spray(args[]){

	//TE_SPRAY
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte (120) // Throws a shower of sprites or models
	write_coord(args[0]) // start pos
	write_coord(args[1])
	write_coord(args[2])
	write_coord(args[3]) // velocity
	write_coord(args[4])
	write_coord(args[5])
	write_short (gSpriteBubble) // spr
	write_byte (6) // count
	write_byte (70) // speed
	write_byte (100) //(noise)
	write_byte (1) // (rendermode)
	message_end()
}
//----------------------------------------------------------------------------------------------
check_bubblezone(id,vec[],aimvec[],speed1,speed2,radius)
{
	new tbody,tid
	get_user_aiming(id,tid,tbody,550)

	if (tid <= 0 || tid > SH_MAXSLOTS) return

	if (get_cvar_num("mp_friendlyfire") == 1) {
		bubble_victim(tid,id)
	}
	else if (get_user_team(id) != get_user_team(tid)) {
		bubble_victim(tid,id)
	}

	new bubblevec1[3],bubblevec2[3],length1

	bubblevec1[0]=aimvec[0]-vec[0]
	bubblevec1[1]=aimvec[1]-vec[1]
	bubblevec1[2]=aimvec[2]-vec[2]

	length1=sqrt(bubblevec1[0]*bubblevec1[0]+bubblevec1[1]*bubblevec1[1]+bubblevec1[2]*bubblevec1[2])
	bubblevec2[0]=bubblevec1[0]*speed2/length1
	bubblevec2[1]=bubblevec1[1]*speed2/length1
	bubblevec2[2]=bubblevec1[2]*speed2/length1
	bubblevec1[0]=bubblevec1[0]*speed1/length1
	bubblevec1[1]=bubblevec1[1]*speed1/length1
	bubblevec1[2]=bubblevec1[2]*speed1/length1
	bubblevec1[0] += vec[0]
	bubblevec1[1] += vec[1]
	bubblevec1[2] += vec[2]
	bubblevec2[0] += vec[0]
	bubblevec2[1] += vec[1]
	bubblevec2[2] += vec[2]

	new origin[3]
	for (new i = 1; i <= SH_MAXSLOTS; i++)  {
		if ( is_user_alive(i) && (i != id) && ( get_cvar_num("mp_friendlyfire") || get_user_team(id) != get_user_team(i) ) )  {
			get_user_origin(i,origin)
			if (get_distance(origin,bubblevec1) < radius) {
				bubble_victim(i,id)
			}
			else if (get_distance(origin,bubblevec2) < radius) {
				bubble_victim(i,id)
			}
		}
	}
}
//----------------------------------------------------------------------------------------------
public bubble_victim(id,killer)
{
	if (gIsBubbling[id]) return

	gIsBubbling[id] = true

	emit_sound(id, CHAN_ITEM, "misc/bubbles.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)

	new args[3]
	args[0] = id
	args[1] = killer
	set_task(0.3,"drowning",451,args,3,"a", get_cvar_num("aquaman_numbubbles") )
	set_task(0.7,"drown_scream",0,args,3)
	set_task(5.5,"stopFireSound",0,args,3)
}
//----------------------------------------------------------------------------------------------
public drowning(args[])
{
	new rx,ry,rz,forigin[3]
	new id = args[0]
	new killer = args[1]
	rx = random_num(-30,30)
	ry = random_num(-30,30)
	rz = random_num(-30,30)
	get_user_origin(id,forigin)

	//TE_SPRITE - additive sprite, plays 1 cycle
	message_begin( MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte( 17 )
	write_coord(forigin[0]+rx) // coord, coord, coord (position)
	write_coord(forigin[1]+ry)
	write_coord(forigin[2]+10+rz)
	write_short( gSpriteBubble ) // short (sprite index)
	write_byte( 30 ) // byte (scale in 0.1's)
	write_byte( 200 ) // byte (brightness)
	message_end()


	if (!is_user_alive(id)) return

	if ( !gHasAquaPower[id] ) {
		Entvars_Set_Float( id, EV_FL_air_finished, Entvars_Get_Float( id, EV_FL_air_finished ) -1)
	}

	new health = get_user_health(id)
	new damage = get_cvar_num("aquaman_bubbledamage")

	if (health - damage  <= 0) {
		shExtraDamage(id, killer, damage, "Bubble Thrower" )
	}
	else { //Prevents the shExtraDamage from saying you attacked a teammate for every cycle of the loop
		set_user_health(id,health - damage)
	}
}
//----------------------------------------------------------------------------------------------
public drown_scream(args[])
{
	emit_sound(args[0], CHAN_AUTO, "scientist/scream1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
}
//----------------------------------------------------------------------------------------------
public stopFireSound(args[])
{
	new sndStop=(1<<5)
	gIsBubbling[args[0]] = false
	emit_sound(args[0], CHAN_ITEM, "vox/_period.wav", 1.0, ATTN_NORM, sndStop, PITCH_NORM)
}
//----------------------------------------------------------------------------------------------
public client_connecct(id)
{
	gHasAquaPower[id] = false
	gIsBubbling[id] = false
}
//----------------------------------------------------------------------------------------------