
 //////////////////////////////////////
 //             PokeMod!             //
 //  The World of Pokemon.... in CS  //
 //////////////////////////////////////
 
 /*
 //--Versions--//
	v1.1.1					- fixed some things, added some cvars, cleaned code, made a little bit ready for when lvls and xp are added
	v1.1.0					- Redid menus, added more pokemon (33 in total), cleaned code, changed cvars to pcvars
							- now requires AMXX 1.71 or greater
	v1.0.1(never released)	- Fixed some stuff, cleaned code, added more cvars
	v1.0.0					- Released to the public

 //--Credits--//
	- Onix					- used sprites, sounds, and fakedamage code from yang's Veronika hero
	- Abra					- used positionChangeCheck code from scoutPractice / JTP10181 's Blink hero
							- used PassAimTest code from sharky / JTP10181 's Batgirl hero
	- Growlithe				- used Cheap_Suit's flamethrower
							- KoST - for the get_distance_to_line stock
							- VEN - for his fm_is_ent_visible stock
	- Kadabra				- based on vittu's SSJ Gohan hero
	- Magmar				- made by Om3gA

	- Config files			- thanks to superheromod
	- Sounds				- used some sounds from FFX mod
	- Models				- used Prof. Oak model from old abandoned Pokemon Mod for Half-Life
							- original pokeball made by Emp`, fixed by Om3gA
	- PokeLoop				- used loop code from {HOJ} Batman/JTP10181 's Captain America hero
	- NPCS					- used Twilight Suzuka's NPC guide thing
							- used mole code from WC3FT mod

		* Anything not listed here was most likely done by Emp`

 //--To Do--//
	- organize sma into smaller files
	- change menus to the new amxx way
	- can only have 6 pokemon
	- levels and xp
	- pokemon evolution
	- admin commands/menu
	- multi-lingual support
	- more pokemon???
	- menu to choose what skill you want to use (if more than one bind skill through evolution)

 */

 #include <amxmodx>
 #include <amxmisc>
 #include <cstrike>
 #include <engine>
 #include <fakemeta>
 #include <fun>
 #include <xs>

 //lets make some defines about pokemod
 #define PLUGNAME		"[PokeMod]"
 #define AUTHOR			"Emp`"
 #define POKETEAM		"Emp`, Om3gA"
 new const VERSION[] =	"1.1.1"
 #define MAX_PLAYERS 32
 #define POKEBALLMDL	"models/pokemon/w_pokeball.mdl"

 //--global messages--//
 new gmsgScreenFade
 new gmsgStatusText
 new gmsgStatusIcon
 new gmsgDeathMsg
 new gmsgSayText

 //--Keys for menu to keep it organized--//
 new allkeys = MENU_KEY_1|MENU_KEY_2|MENU_KEY_3|MENU_KEY_4|MENU_KEY_5|MENU_KEY_6|MENU_KEY_7|MENU_KEY_8|MENU_KEY_9|MENU_KEY_0	//because i found it more useful that all menus have all keys enabled

 //where poke files are located
 new g_PokeDir[128]
 new g_PokeConfig[128]
 new g_Pokehelp[128]
 new g_Pokedex[128]
 new g_Pokedex2[128]
 new debugt[256]

 //--For PCVARS--//
 new pm_pokemod, pm_debug, pm_maxhp, pm_botsays, pm_pokecenter, pm_oakheal, pm_items
 new pm_bulbtime, pm_leech, pm_bellstime, pm_whip, pm_whipdamage, pm_tangela
 new pm_rage, pm_burndamage
 new pm_waterheal, pm_bubbledamage, pm_bubblenum, pm_starmietime, pm_recover, pm_politime, pm_polidist
 new pm_voltorb, pm_voltdamage
 new pm_geodudetime, pm_harden, pm_onixtime, pm_rockthrow
 new pm_abratime, pm_teletime, pm_kadatime, pm_psybeam
 new pm_stringtime, pm_venonattime, pm_powdertime
 new pm_poisontime, pm_poison
 new pm_maxfade, pm_minfade, pm_hauntertime, pm_sleeptime
 new pm_chantime, pm_snorlax

 //--NPC stuff--//
 new spawnEntString[2][] = {"info_player_start","info_player_deathmatch"}
 new bool:spawnPointsused[MAX_PLAYERS+1] = false
 new PCent[3]

 //--Pokemon stuff--//
 new Pokemon[MAX_PLAYERS+1]		//which pokemon a player has

 //Eventually these defines will be in a seperate file
 #define BULBASAUR  1
 #define BELLSPROUT  69
 #define TANGELA  114
 #define CHARMANDER  4
 #define GROWLITHE  58
 #define MAGMAR  126
 #define SQUIRTLE  7
 #define STARMIE  121
 #define POLIWHIRL  61
 #define PIKACHU  25
 #define VOLTORB  100
 #define ELECTRABUZZ  125
 #define GEODUDE  74
 #define ONIX  95
 #define AERODACTYL  142
 #define ABRA  63
 #define KADABRA  64
 #define ALAKAZAM  65
 #define CATERPIE  10
 #define VENONAT  48
 #define PINSIR  127
 #define ARBOK  24
 #define WEEZING  110
 #define ZUBAT  41
 #define GASTLY  92
 #define HAUNTER  93
 #define GENGAR  94
 #define PIDGEY  16
 #define MEOWTH  52
 #define CHANSEY  113
 #define DODUO  84
 #define PORYGON  137
 #define SNORLAX  143
 
 #define GRASS  1
 #define FIRE  2
 #define WATER  3
 #define ROCK  4
 #define ELECTRIC  5
 #define PSYCHIC  6
 #define BUG  7
 #define POISON  8
 #define GHOST  9
 #define NORMAL  10

 new origin[MAX_PLAYERS+1][3]			//different players origins
 new BindUsed[MAX_PLAYERS+1]			//this is used to have delays between pokemon skill uses
 new maxhp[MAX_PLAYERS+1]				//this is a players maxhp for pokemod
 new bool:g_isStopped[MAX_PLAYERS+1]	//when someone shouldn't be able to move
 new bool:g_isSkilled[MAX_PLAYERS+1]	//when someone is pressing +pokeskill
 new bool:g_isItemed[MAX_PLAYERS+1]		//when someone is pressing +pokeitem

 //--Grass Pokemon stuff--//
 new bool:g_isLeeched[MAX_PLAYERS+1]
 new rope

 //--Fire Pokemon stuff--//
 new rage[MAX_PLAYERS+1]
 new explode1
 new xfire
 new ballsmoke
 new bool:g_isBurning[MAX_PLAYERS+1]

 //--Water Pokemon stuff--//
 new bubbles[MAX_PLAYERS+1]
 new bubble

 //--Electric Pokemon stuff--//
 new shockwave
 new gxplode
 new steam1

 //--Rock Pokemon stuff--//
 new xplode
 new aim[MAX_PLAYERS+1][3]
 new g_lastPosition[MAX_PLAYERS+1][3]
 new checkCount[MAX_PLAYERS+1]

 //--Psychic Pokemon stuff--//
 new psybeamID[MAX_PLAYERS+1]
 new trail

 //--Bug Pokemon stuff--//
 
 //--Poison Pokemon stuff--//
 new arbok
 new gas
 new cpois[MAX_PLAYERS+1]

 //--Ghost Pokemon stuff--//
 new gtime
 new bool:g_isAsleep[MAX_PLAYERS+1]
 
 //--Normal Pokemon stuff--//
 new bool:g_isSlow[MAX_PLAYERS+1]
 new bool:g_canFly[MAX_PLAYERS+1]
 new EggBomb[MAX_PLAYERS+1]


 //--Item stuff--//
 new bool:NightVisionUse[MAX_PLAYERS+1]
 new zbeam6
 new bool:g_isRiding[MAX_PLAYERS+1]
 new Item[MAX_PLAYERS+1][9]		//allows a player to have multiple of an item
 new CostArray[9] = {	//costs for items in pokemart
	300,	//potion
	100,	//antidote
	550,	//escape rope
	600,	//full heal
	700,	//super potion
	1500,	//hyper potion
	3000,	//full restore
	5000,	//bicycle
	9800	//hp up
 }
 
 
 //--Speed stuff--//
 #define FASTSPEED 100	//how much speed is added for bikes
 #define SLOWSPEED 150	//how much speed is subtracted for slow
 
 

 /////////////////////
 //--Starts plugin--//
 /////////////////////
 public plugin_init()
 {
	register_plugin(PLUGNAME, VERSION, AUTHOR)
	
	//Thanks to SuperHeroMod
	register_cvar("PokeMod_Version",VERSION,FCVAR_SERVER|FCVAR_SPONLY)
	set_cvar_string("PokeMod_Version",VERSION)

	SetupConfig()

	//The different menus
	register_menucmd(register_menuid("\rGrass Pokemon:"),1023,"GrassChoices")
	register_menucmd(register_menuid("\rFire Pokemon:"),1023,"FireChoices")
	register_menucmd(register_menuid("\rWater Pokemon:"),1023,"WaterChoices")
	register_menucmd(register_menuid("\rElectric Pokemon:"),1023,"ElectricChoices")
	register_menucmd(register_menuid("\rRock Pokemon:"),1023,"RockChoices")
	register_menucmd(register_menuid("\rPsychic Pokemon:"),1023,"PsychicChoices")
	register_menucmd(register_menuid("\rBug Pokemon:"),1023,"BugChoices")
	register_menucmd(register_menuid("\rPoison Pokemon:"),1023,"PoisonChoices")
	register_menucmd(register_menuid("\rGhost Pokemon:"),1023,"GhostChoices")
	register_menucmd(register_menuid("\rNormal Pokemon:"),1023,"NormalChoices")

	register_menucmd(register_menuid("\rPokemon Types:\R\w(1/2)"),1023,"TypeChoices")
	register_menucmd(register_menuid("\rPokemon Types:\R\w(2/2)"),1023,"Type2Choices")
	register_menucmd(register_menuid("\rPoke Mart:"),1023,"ShopChoices")
	register_menucmd(register_menuid("\rPoke Center:"),1023,"MenuChoices")
	register_menucmd(register_menuid("\rYour Items:"),1023,"ItemUseChoices")

	//Base PokeMod Cvars
	pm_pokemod = register_cvar("pm_pokemod","1")
	pm_debug = register_cvar("pm_debug","0")
	pm_maxhp = register_cvar("pm_maxhp","255")
	pm_botsays = register_cvar("pm_botsays","1")
	pm_pokecenter = register_cvar("pm_pokecenter","200")
	pm_oakheal = register_cvar("pm_oakheal", "1")
	pm_items = register_cvar("pm_items","abcdefghi")

	//Grass Cvars
	pm_bulbtime = register_cvar("pm_bulbtime","10")
	pm_leech = register_cvar("pm_leech","5")
	pm_bellstime = register_cvar("pm_bellstime","5")
	pm_whip = register_cvar("pm_whip","500")
	pm_whipdamage = register_cvar("pm_whipdamage","25")
	pm_tangela = register_cvar("pm_tangela","1.5")

	//Fire Cvars
	pm_rage = register_cvar("pm_rage","5")
	pm_burndamage = register_cvar("pm_burndamage","5")

	//Water Cvars
	pm_waterheal = register_cvar("pm_waterheal","3")
	pm_bubbledamage = register_cvar("pm_bubbledamage","25")
	pm_bubblenum = register_cvar("pm_bubblenum","10")
	pm_starmietime = register_cvar("pm_starmietime","10")
	pm_recover = register_cvar("pm_recover","0.3")
	pm_politime = register_cvar("pm_politime","7")
	pm_polidist = register_cvar("pm_polidist","500")

	//Electric Cvars
	pm_voltorb = register_cvar("pm_voltorb","500")
	pm_voltdamage = register_cvar("pm_voltdamage","150")

	//Rock Cvars
	pm_geodudetime = register_cvar("pm_geodudetime","5")
	pm_harden = register_cvar("pm_harden","1")
	pm_onixtime = register_cvar("pm_onixtime","5")
	pm_rockthrow = register_cvar("pm_rockthrow","100")

	//Psychic Cvars
	pm_abratime = register_cvar("pm_abratime","5")
	pm_teletime = register_cvar("pm_teletime","2")
	pm_kadatime = register_cvar("pm_kadatime","10")
	pm_psybeam = register_cvar("pm_psybeam","150")

	//Bug Cvars
	pm_stringtime = register_cvar("pm_stringtime","10")
	pm_venonattime = register_cvar("pm_venonattime","5")
	pm_powdertime = register_cvar("pm_powdertime","10")

	//Poison Cvars
	pm_poisontime = register_cvar("pm_poisontime","10")
	pm_poison = register_cvar("pm_poison","5")

	//Ghost Cvars
	pm_maxfade = register_cvar("pm_maxfade","200")
	pm_minfade = register_cvar("pm_minfade","0")
	pm_hauntertime = register_cvar("pm_hauntertime","10")
	pm_sleeptime = register_cvar("pm_sleeptime","5")

	//Normal Cvars
	pm_chantime = register_cvar("pm_chantime","5")
	pm_snorlax = register_cvar("pm_snorlax","1")

	//Events
	register_clcmd("nightvision","SilphScope") 
	register_event("ItemStatus", "event_buynvg", "b", "1=1")
	register_event("Damage", "pokemon_damage", "b", "2!0")
	register_event("ResetHUD", "pokemon_spawn", "b")
	register_event("DeathMsg", "pokemon_death", "a")
	register_event("AmmoX", "pokemon_ammox", "b")
	register_event("StatusText", "pokemon_statustext", "b");
	register_logevent("pokemon_round", 2, "1=Round_Start")
	register_event("CurWeapon", "WeaponChange", "be", "1=1")

	//Loop every second
	set_task(1.0, "pokemon_loop", 0, "", 0, "b")

	//Client Say Commands
	register_clcmd("say","HandleSay")

	//Client Console commands
	register_clcmd("+pokeskill","pokeskill_down",ADMIN_ALL, "- uses pokemon bind skill")
	register_clcmd("-pokeskill","pokeskill_up",ADMIN_ALL, "- stops pokemon bind skill")
	register_clcmd("+pokeitem","pokeitem_down",ADMIN_ALL, "- brings up Item Menu")
	register_clcmd("-pokeitem","pokeitem_up",ADMIN_ALL, "- brings down Item Menu")
	register_clcmd("pokeskill","updatecommands")	//this just tells them to rebind with a +
	register_clcmd("pokeitem","updatecommands")		//this just tells them to rebind with a +
	register_clcmd("fullupdate","fullupdate")		//this just blocks the fullupdate abuse

	//Admin Commands
	register_concmd("pm_setpoke","admin_setpoke",ADMIN_SLAY,"<nick> <pokemon name>")
	register_concmd("pm_reset","admin_reset",ADMIN_RCON," - resets pokemod files")
	register_concmd("pm_loadconfig","admin_loadconfig",ADMIN_BAN," - loads pokemod config file")

	//Global Messages
	gmsgScreenFade	= get_user_msgid("ScreenFade")
	gmsgStatusText	= get_user_msgid("StatusText")
	gmsgStatusIcon	= get_user_msgid("StatusIcon")
	gmsgDeathMsg	= get_user_msgid("DeathMsg")
	gmsgSayText		= get_user_msgid("SayText")
 }
 ///////////////////////
 //--Precached Items--//
 ///////////////////////
 public plugin_precache()
 {
	//Only Custom Pokemon files need to be downloaded

	//Precached Sounds
	precache_sound("hornet/ag_hornethit1.wav")
	precache_sound("turret/tu_ping.wav")
	precache_sound("turret/tu_fire1.wav")
	precache_sound("common/bodydrop1.wav")
	precache_sound("ambience/particle_suck1.wav")
	precache_sound("ambience/burning1.wav")
	precache_sound("ambience/flameburst1.wav")
	precache_sound("vox/_period.wav")
	//Custom Pokemon Sounds
	precache_sound("pokemon/pokecenter.wav")
	precache_sound("pokemon/a_exm2.wav")
	precache_sound("pokemon/noisy.wav")
	precache_sound("pokemon/cure.wav")
	precache_sound("pokemon/cast.wav")

	//Precached Sprites
	rope = 		precache_model("sprites/rope.spr")
	bubble = 	precache_model("sprites/bubble.spr")
	gas = 		precache_model("sprites/poison.spr")
	shockwave =	precache_model("sprites/shockwave.spr")
	gxplode =	precache_model("sprites/zerogxplode.spr")
	steam1 =	precache_model("sprites/steam1.spr")
	explode1 =	precache_model("sprites/explode1.spr")
	xfire =		precache_model("sprites/xfire.spr")
	ballsmoke =	precache_model("sprites/ballsmoke.spr")
	zbeam6 =	precache_model("sprites/zbeam6.spr")
	//Custom Pokemon Sprites
	xplode = 	precache_model("sprites/pokemon/zerogxplode2.spr")
	arbok = 	precache_model("sprites/pokemon/arbok.spr")
	trail =		precache_model("sprites/pokemon/psybeam.spr")

	//Precached Models
	precache_model("models/big_rock.mdl")
	precache_model("models/bleachbones.mdl")
	precache_model("models/teleporter_blue_sprites.mdl")
	//Custom Pokemon Models
	precache_model(POKEBALLMDL)
	precache_model("models/pokemon/oak.mdl")
	precache_model("models/pokemon/oakT.mdl")
 }
 /////////////////////////
 //--Read Config Files--//
 /////////////////////////
 public SetupConfig()
 {
	//Set Up Config Files
	new configDir[128]
	get_configsdir(configDir,127)
	format(g_PokeDir,127,"%s/pokemon/",configDir)
	format(g_PokeConfig,127,"%s/pokemon/pokemod.cfg",configDir)
	format(g_Pokehelp,127,"%s/pokemon/pokehelp.txt",configDir)
	format(g_Pokedex,127,"%s/pokemon/pokedex.txt",configDir)
	format(g_Pokedex2,127,"%s/pokemon/pokedex2.txt",configDir)
	
	if(!dir_exists(g_PokeDir))
		mkdir(g_PokeDir)

	set_task(5.0,"LoadConfig")
 }
 public LoadConfig()
 {
	//Load Config Files
	if(file_exists(g_PokeConfig)) {
		server_cmd("exec %s",g_PokeConfig)
	}
	else {
		format(debugt,255,"**WARNING** PokeMod Config File not found, making default configs")
		debugMessage(debugt,0,0)
		ResetConfig()
	}
	if(!file_exists(g_Pokehelp)){
		format(debugt,255,"**WARNING** PokeMod Pokehelp File not found, making default")
		debugMessage(debugt,0,0)
		Make_Pokehelp()
	}
	if(!file_exists(g_Pokedex)){
		format(debugt,255,"**WARNING** PokeMod Pokedex not found, making default")
		debugMessage(debugt,0,0)
		Make_Pokedex()
	}
	if(!file_exists(g_Pokedex2)){
		format(debugt,255,"**WARNING** PokeMod Pokedex2 not found, making default")
		debugMessage(debugt,0,0)
		Make_Pokedex2()
	}
 }
 public ResetConfig()
 {
	if(file_exists(g_PokeConfig))
		delete_file(g_PokeConfig)

	write_file(g_PokeConfig,	"",-1)
	write_file(g_PokeConfig,	"//CVARS for PokeMod, these are loaded every map change ",-1)
	write_file(g_PokeConfig,	"",-1)
	write_file(g_PokeConfig,	"//Main Cvars ",-1)
	write_file(g_PokeConfig,	"pm_pokemod 1		//turns pokemod on and off (1=on, 0=off) ",-1)
	write_file(g_PokeConfig,	"pm_debug 0			//turns pokemod debug messages on and off (1=on, 0=off) ",-1)
	write_file(g_PokeConfig,	"pm_maxhp 255		//max hp that someone can get with HP Ups ",-1)
	write_file(g_PokeConfig,	"pm_botsays 1		//turns on bot radio commands when they ",-1)
	write_file(g_PokeConfig,	"					//choose/buy a pokemon/item ",-1)
	write_file(g_PokeConfig,	"pm_pokecenter 200	//set to 0 if you dont want the npcs to be spawned. ",-1)
	write_file(g_PokeConfig,	"					//otherwise this is the distance you can be from ",-1)
	write_file(g_PokeConfig,	"					//pokecenter to heal and 2.5x distance you have to ",-1)
	write_file(g_PokeConfig,	"					//be from pokecenter to use escape rope. ",-1)
	write_file(g_PokeConfig,	"pm_oakheal 1		//can users heal at prof oak (1 = yes, 0 = no)",-1)
	write_file(g_PokeConfig,	"pm_items abcdefghi	//items available at the poke",-1)
	write_file(g_PokeConfig,	"					//a=Potion, b=Antidote, c=Escape Rope, d=Full Heal",-1)
	write_file(g_PokeConfig,	"					//e=Spotion, f=Hpotion, g=Full Restore, h=Bike, i=HPup",-1)
	write_file(g_PokeConfig,	"",-1)
	write_file(g_PokeConfig,	"//Grass Pokemon Cvars ",-1)
	write_file(g_PokeConfig,	"pm_bulbtime 10		//seconds until you can use bulbasaurs skill again  ",-1)
	write_file(g_PokeConfig,	"pm_leech 5			//ammount of hp to leech every leechtime if target ",-1)
	write_file(g_PokeConfig,	"					//is being leeched ",-1)
	write_file(g_PokeConfig,	"pm_bellstime 5		//seconds until you can use bellsprouts skill again ",-1)
	write_file(g_PokeConfig,	"pm_whip 500		//how much knockback vine whip does ",-1)
	write_file(g_PokeConfig,	"pm_whipdamage 25	//how much damage vine whip does ",-1)
	write_file(g_PokeConfig,	"pm_tangela 1.5		//how much damage is returned as ap ",-1)
	write_file(g_PokeConfig,	"",-1)
	write_file(g_PokeConfig,	"//Fire Pokemon Cvars ",-1)
	write_file(g_PokeConfig,	"pm_rage 5			//1 extra damage for this ammount of hp ",-1)
	write_file(g_PokeConfig,	"pm_burndamage 5	//how much stepping on fire or being burnt does ",-1)
	write_file(g_PokeConfig,	"",-1)
	write_file(g_PokeConfig,	"//Water Pokemon Cvars ",-1)
	write_file(g_PokeConfig,	"pm_waterheal 3		//how much hp is healed per second in water (if user is a water pokemon) ",-1)
	write_file(g_PokeConfig,	"pm_bubbledamage 25	//damage of bubble beam ",-1)
	write_file(g_PokeConfig,	"pm_bubblenum 10	//number of bubble beams each round and after charged ",-1)
	write_file(g_PokeConfig,	"pm_starmietime 5	//seconds until you can use starmies skill again ",-1)
	write_file(g_PokeConfig,	"pm_recover 0.5		//how much damage you recover ",-1)
	write_file(g_PokeConfig,	"					//this times your max hp - current hp = hp recovered ",-1)
	write_file(g_PokeConfig,	"pm_politime 7		//seconds until you can use poliwhirls skill again ",-1)
	write_file(g_PokeConfig,	"pm_polidist 500	//users within this distance will be confused ",-1)
	write_file(g_PokeConfig,	"",-1)
	write_file(g_PokeConfig,	"//Electric Pokemon Cvars ",-1)
	write_file(g_PokeConfig,	"pm_voltorb 500		//radius for self destruct damage ",-1)
	write_file(g_PokeConfig,	"pm_voltdamage 150	//max damage for self destruct ",-1)
	write_file(g_PokeConfig,	"",-1)
	write_file(g_PokeConfig,	"//Rock Pokemon Cvars ",-1)
	write_file(g_PokeConfig,	"pm_geodudetime 5	//seconds until you can use geodudes skill again ",-1)
	write_file(g_PokeConfig,	"pm_harden 1		//how much hp he gets per armor ",-1)
	write_file(g_PokeConfig,	"pm_onixtime 5		//seconds until you can use onixs skill again ",-1)
	write_file(g_PokeConfig,	"pm_rockthrow 100	//max damage of getting hit by a boulder ",-1)
	write_file(g_PokeConfig,	"					//if your hit by the boulder then it does this ammount ",-1)
	write_file(g_PokeConfig,	"",-1)
	write_file(g_PokeConfig,	"//Psychic Pokemon Cvars ",-1)
	write_file(g_PokeConfig,	"pm_abratime 10		//seconds until you can use abras skill again ",-1)
	write_file(g_PokeConfig,	"pm_abra 1			//seconds until user teleports ",-1)
	write_file(g_PokeConfig,	"pm_kadatime 10		//seconds until you can use kadabras skill again ",-1)
	write_file(g_PokeConfig,	"pm_psybeam 150		//max damage of psybeam ",-1)
 	write_file(g_PokeConfig,	"",-1)
	write_file(g_PokeConfig,	"//Bug Pokemon Cvars ",-1)
	write_file(g_PokeConfig,	"pm_stringtime 10	//how long someone is slow if they are string shot ",-1)
	write_file(g_PokeConfig,	"pm_venonattime 5	//seconds until you can use venonats skill again ",-1)
	write_file(g_PokeConfig,	"pm_powdertime 5	//seconds that you drop sleep powder ",-1)
	write_file(g_PokeConfig,	"",-1)
	write_file(g_PokeConfig,	"//Poison Pokemon Cvars ",-1)
	write_file(g_PokeConfig,	"pm_poison 5		//damage of poison attacks (weezing and arbok) ",-1)
	write_file(g_PokeConfig,	"pm_poisontime 10	//seconds that poison lasts ",-1)
	write_file(g_PokeConfig,	"",-1)
	write_file(g_PokeConfig,	"//Ghost Pokemon Cvars ",-1)
	write_file(g_PokeConfig,	"pm_maxfade 200		//this is the maximum transparency of gastly (255-0) ",-1)
	write_file(g_PokeConfig,	"pm_minfade 0		//this is the minimum transparency of gastly (255-0) ",-1)
	write_file(g_PokeConfig,	"pm_hauntertime 10	//seconds until you can use haunters skill again ",-1)
	write_file(g_PokeConfig,	"					//(after eating a dream) ",-1)
	write_file(g_PokeConfig,	"pm_sleeptime 5		//seconds of blackness while your asleep ",-1)
 	write_file(g_PokeConfig,	"",-1)
	write_file(g_PokeConfig,	"//Normal Pokemon Cvars ",-1)
	write_file(g_PokeConfig,	"pm_chantime 5		//seconds until you can get another grenade ",-1)
	write_file(g_PokeConfig,	"pm_snorlax 1		//how much hp is healed while crouching ",-1)
	write_file(g_PokeConfig,	"",-1)
 	write_file(g_PokeConfig,	"",-1)
	write_file(g_PokeConfig,	"echo ^"PokeMod - Successfully Loaded PokeMod Config File^" ",-1)

 }

 //--Every time someone connects, make sure they have no pokemon and no items--//
 public client_connect(id)
 {
	Pokemon[id] = 0
	NoItems(id)
 }
 //--Every time someone disconnects--//
 public client_disconnect(id)
 {
	return PLUGIN_CONTINUE
 }
 //--Tests whether or not PokeMod is on--//
 public PMon()
 {
	if(get_pcvar_num(pm_pokemod)>=1) return 1
	return 0
 }

 //--Every ResetHUD--//
 public pokemon_spawn(id)
 {
	if(!is_user_alive(id) || !is_user_connected(id)) return

	new a = Team(id)
	if(1>a>2) return

	//Stop if PokeMod is not on
	if(!PMon()) return

	//Auto Things for bots
	if(is_user_bot(id))
		BotCenter(id)

	//Do other stuff such as setting hp and removing pokemon statuses

	CheckMaxHP(id)
	if(maxhp[id] > 100) set_user_health(id, maxhp[id])

	ResetSkills(id)
	ResetStatus(id)

	PokeDisplay(id, id)
	bind_hud(id, 1)
	SetSpeed(id)

	if(!task_exists(id+777))
		set_task(1.0, "Oak_Check", id+777)
 }
 //--Every Round Start--//
 public pokemon_round()
 {
	//Remove old npcs
	if(!PMon() || get_pcvar_num(pm_pokecenter)==0){
		if(is_valid_ent(PCent[1])) remove_entity(PCent[1])
		if(is_valid_ent(PCent[2])) remove_entity(PCent[2])
	}
	else {
		if(!is_valid_ent(PCent[1])) npc_pokecenter(1)
		if(!is_valid_ent(PCent[2])) npc_pokecenter(2)
	}

	while(find_ent_by_class(-1,"pokeitem") != 0)
		remove_entity(find_ent_by_class(-1,"pokeitem"))

 }
 //--Checks to see if they spawned in Oak--//
 public Oak_Check(num)
 {
	new id = num-777
	if(is_user_alive(id)){
		new Float:porigin[3]
		new Float:vicinity = 100.0		//players dimentions (32x32x96), but just incase for some reasons, they get stuck by a little, lets make it 100
		new playersInVicinity = 0
		new entList[1]

		entity_get_vector(id,EV_VEC_origin,porigin)

		playersInVicinity += find_sphere_class(0, "player", vicinity, entList, 1, porigin)
		playersInVicinity += find_sphere_class(0, "npc_pokecenter", vicinity, entList, 1, porigin)

		if(playersInVicinity > 0)
			EscapeRope(id, 0)
	}
 }
 //--When someone aims at someone else--//
 public pokemon_statustext(id)
 {
	if(!is_user_alive(id) || !PMon()) return

	new abody,aid
	get_user_aiming(id, aid, abody)

	if(is_user_alive(aid)){
		PokeDisplay(id, aid)
	
		//pokemon that use aiming
		if(Team(aid)!=Team(id) && !BindUsed[id]){
			switch(Pokemon[id])
			{
				case BULBASAUR:{
					Bulbasaur_keydown(id)
				}
				case BELLSPROUT:{
					Bellsprout_keydown(id)
				}
			}
		}
	}
 }
 public ResetStatus(id)
 {
	if(g_isBurning[id]){
		g_isBurning[id] = false
		stopFireSound(id)
	}
	g_isLeeched[id] = false

	cpois[id] = 0
	g_isAsleep[id] = false
	g_isStopped[id] = false
	screenflash(id,0,0,0,0)
	g_isRiding[id] = false

	SetSpeed(id)
 }
 public ResetSkills(id)
 {
	set_user_rendering(id, kRenderFxGlowShell, 0, 0, 0, kRenderTransAlpha, 255)
	bubbles[id] = get_pcvar_num(pm_bubblenum)
	screenflash(id,0,0,0,0)
	EggBomb[id] = 0
	if(is_valid_ent(psybeamID[id]))
		remove_entity(psybeamID[id])
 }
 //--When someone dies--//
 public pokemon_death()
 {
	if(!PMon()) return PLUGIN_CONTINUE

	new id = read_data(2)
	
	if(Pokemon[id]==VOLTORB)
		BlowUp(id)

	BindUsed[id] = true
	bind_hud(id, 0)
 	maxhp[id] = 100

	ResetSkills(id)
	ResetStatus(id)
	rage[id] = 0

	if(!PokeItem(id)) return PLUGIN_CONTINUE

	//Makes pokeball for item drops

	new itemname[25], inum
	for(new i = 0; i<9; i++){
		if(HasPokeItem(id,i))
			inum = i
	}
	ItemToName(inum, itemname)

	new Float:origin[3], Float:angle[3] 
	entity_get_vector(id, EV_VEC_origin, origin)
	entity_get_vector(id, EV_VEC_v_angle, angle)

	new mark = create_entity("info_target")

	entity_set_string(mark,EV_SZ_classname, "pokeitem")
	entity_set_string(mark,EV_SZ_targetname, itemname)
	entity_set_model(mark,POKEBALLMDL);
	entity_set_int(mark,EV_INT_solid,1)

	new Float:maxs[3] = {5.0,5.0,5.0}
	new Float:mins[3] = {-5.0,-5.0,-5.0}
	entity_set_size(mark,mins,maxs)

	entity_set_origin(mark, origin)
	entity_set_vector(mark, EV_VEC_angles, angle)

	entity_set_float(mark,EV_FL_scale,0.2)

	entity_set_int(mark, EV_INT_movetype, 6)

	drop_to_floor(mark)

	NoItems(id)

	return PLUGIN_CONTINUE
 }

 //--Blocks FullUpdate Abuse--//
 public fullupdate(id)
 {
	return PLUGIN_HANDLED_MAIN
 }
 //--Tells players to update their binds--//
 public updatecommands(id)
 {
	new message[129]
	format(message, 128, "^x04 %s Please rebind your keys to +pokeskill and +pokeitem.",PLUGNAME)

	message_begin(MSG_ONE, gmsgSayText, {0,0,0}, id)
	write_byte(id)
	write_string(message)
	message_end()
 }
 //--When someone press pokemenu--//
 public pokeskill_down(id)
 {
	g_isSkilled[id] = true

	if(!PMon()){
		client_print(id,print_chat, "%s PokeMod is currently disabled.",PLUGNAME)
		return PLUGIN_HANDLED
	}
	else if(Pokemon[id]==0)
									TypeMenu(id)
	else if (BindUsed[id] || !is_user_alive(id))
									sounddeny(id)

	else {

		switch(Pokemon[id]){
			//Grass
			case BULBASAUR: 			Bulbasaur_keydown(id)
			case BELLSPROUT:			Bellsprout_keydown(id)
			//Fire
			case GROWLITHE:				Growlithe_keydown(id)
			case MAGMAR:				Magmar_keydown(id)
			//Water
			case SQUIRTLE:				Squirtle_keydown(id)
			case STARMIE:				Starmie_keydown(id)
			case POLIWHIRL:				Poliwhirl_keydown(id)
			//Electric
			case VOLTORB:				pokedamage(id, id, 100*Health(id), "Self-Destruct")
			//Rock
			case GEODUDE:				Geodude_keydown(id)
			case ONIX:					Onix_keydown(id)

			//Psychic
			case ABRA:					Abra_keydown(id)
			case KADABRA:				Kadabra_keydown(id)
			//Bug
			case VENONAT: 				Venonat_keydown(id)
			//Poison
			//Ghost
			case HAUNTER: 				Haunter_keydown(id)
			//Normal
			case CHANSEY: 				Chansey_keydown(id)

			default:					sounddeny(id)
		}
	}

	return PLUGIN_HANDLED
 }
 public pokeskill_up(id)
 {
	g_isSkilled[id] = false
	return PLUGIN_HANDLED
 }
 public pokeitem_down(id)
 {
	g_isItemed[id] = true
	ItemUseMenu(id)
	return PLUGIN_HANDLED
 }
 public pokeitem_up(id)
 {
	g_isItemed[id] = false
	return PLUGIN_HANDLED
 }
 
 //--When a client says something--//
 public HandleSay(id)
 {
	new said[192]
	read_args(said,191)
	remove_quotes(said)

	//remove the / if it is there
	if(equali(said,"/",1 ))
		copy( said, 191, said[1]);

	if((containi(said, "say") != -1 ) || (containi(said, "type") != -1 ))
		return PLUGIN_CONTINUE
	if(!PMon()){
		if(containi(said, "poke") != -1) {
			client_print(id,print_chat, "%s PokeMod is currently disabled.",PLUGNAME)
			return PLUGIN_CONTINUE
		}
	}
	else {
		if(((equali(said,"help",4 )) && (containi(said, "poke") != -1 )) || ((equali(said,"poke",4 )) && (containi(said, "help") != -1 )) ) {
			pokehelp(id)
			return PLUGIN_CONTINUE
		}
		else if(equali(said, "pokedex",7)) {
			if(equali(said, "pokedex2",8)) pokedex2(id)
			else pokedex(id)
			return PLUGIN_CONTINUE
		}
		else if(equali(said, "reselect",8) || equali(said, "come back",9) || (equali(said, "drop",4) && (containi(said, "poke") != -1 )) ) {
			Pokemon[id] = 0
			set_user_rendering(id, kRenderFxGlowShell, 0, 0, 0, kRenderTransAlpha, 255)
			TypeMenu(id)
			return PLUGIN_CONTINUE
		}
		else if(((containi(said, "how") != -1)||(containi(said, "?") != -1))&&((containi(said, "poke") != -1)||(containi(said, "power") != -1)||(containi(said, "skill") != -1))) {
			client_print(id,print_chat, "%s For help with PokeMod, say: /pokehelp",PLUGNAME)
			return PLUGIN_CONTINUE
		}
		else if(containi(said, "poke") != -1 && ((containi(said, "maker") != -1)||(containi(said, "creator") != -1)||(containi(said, "team") != -1))) {
			client_print(id,print_chat, "%s PokeMod Team: %s",PLUGNAME, POKETEAM)
			return PLUGIN_CONTINUE
		}
		else if(equali(said, "go",2)) {
			new Left[25], Right[151], Final[151], pid
			strbrkqt(said, Left, 24, Right, 150)
			strbrkqt(Right, Left, 24, Final, 150)
			pid = NameToPoke(Left)
			if(BindPoke(pid)||NonBindPoke(pid))
				Pokemon[id] = pid
			return PLUGIN_CONTINUE
		}
	}
	return PLUGIN_CONTINUE
 }
 
 //--When someone wants to look at the pokehelp--//
 public pokehelp(id)
 {
	show_motd( id, g_Pokehelp, "Pokehelp" )
	return PLUGIN_HANDLED
 }
 
 //--When someone wants to look at the pokedex files--//
 public pokedex(id)
 {
	show_motd( id, g_Pokedex, "Pokedex" )
	return PLUGIN_HANDLED
 }
 public pokedex2(id)
 {
	show_motd( id, g_Pokedex2, "Pokedex2" )
	return PLUGIN_HANDLED
 }
 /////////////
 //--Menus--//
 /////////////
 //--GrassMenu--//
 public GrassMenu(id)
 {
	new menuBody[1024]

	format(menuBody, 1023, "\rGrass Pokemon:^n^n \w1.  \yBulbasaur\R\wLeech Seed^n 2.  \yBellsprout\R\wVine Whip^n 3.  \yTangela\R\wAbsorb^n^n9. Pokedex^n0. Cancel")

	show_menu(id, allkeys, menuBody)
 }
 public GrassChoices(id, key)
 {
	switch(key)
	{
		case 0:
		{
			Pokemon[id] = BULBASAUR
			screenflash(id, 0, 255, 0, 50)
			client_print(id, print_chat, "%s You now have bulbasaur's leech seed! Slowly drain someone's HP!",PLUGNAME)
		}
		case 1:
		{
			Pokemon[id] = BELLSPROUT
			screenflash(id, 0, 255, 0, 50)
			client_print(id, print_chat, "%s You now have bellsprout's vine whip! Whip players away from you!",PLUGNAME)
		}
		case 2:
		{
			Pokemon[id] = TANGELA
			screenflash(id, 0, 255, 100, 50)
			client_print(id, print_chat, "%s You now have tangela's absorb! Absorb enemies AP!",PLUGNAME)
		}
		case 8: pokedex(id)
		case 9: TypeMenu(id)
	}
	bind_hud(id, 1)
	SetSpeed(id)
	return PLUGIN_HANDLED
 }
 //--FireMenu--//
 public FireMenu(id)
 {
	new menuBody[1024]

	format(menuBody, 1023, "\rFire Pokemon:^n^n \w1.  \yCharmander\R\wRage^n 2.  \yGrowlithe\R\wFlame Thrower^n 3.  \yMagmar\R\wSmokescreen^n^n9. Pokedex^n0. Cancel")

	show_menu(id, allkeys, menuBody)
 }
 public FireChoices(id, key)
 {
	switch(key)
	{
		case 0:
		{
			Pokemon[id] = CHARMANDER
			screenflash(id, 255, 0, 0, 50)
			client_print(id, print_chat, "%s You now have charmander's rage! Do more damage after being hit!",PLUGNAME)
		}
		case 1:
		{
			Pokemon[id] = GROWLITHE
			screenflash(id, 139, 0, 0, 50)
			client_print(id, print_chat, "%s You now have growlithe's flame thrower! Light other players on fire!",PLUGNAME)
		}
		case 2:
		{
			Pokemon[id] = MAGMAR
			screenflash(id, 226, 0, 0, 50)
			client_print(id, print_chat, "%s You now have magmar's smokescreen! Smoke out those badies!",PLUGNAME)
		}
		case 8: pokedex(id)
		case 9: TypeMenu(id)
	}
	bind_hud(id, 1)
	SetSpeed(id)
	return PLUGIN_HANDLED
 }
 //--WaterMenu--//
 public WaterMenu(id)
 {
	new menuBody[1024]

	format(menuBody, 1023, "\rWater Pokemon:^n^n \w1.  \ySquirtle\R\wBubble Beam^n 2.  \yStarmie\R\wRecover^n 3.  \yPoliwhirl\R\wConfusion^n^n9. Pokedex^n0. Cancel")

	show_menu(id, allkeys, menuBody)
 }
 public WaterChoices(id, key)
 {
	switch(key)
	{
		case 0:
		{
			Pokemon[id] = SQUIRTLE
			screenflash(id, 0, 0, 255, 50)
			client_print(id, print_chat, "%s You now have squirtle's bubble beam! Go into water to recharge it!",PLUGNAME)
		}
		case 1:
		{
			Pokemon[id] = STARMIE
			screenflash(id, 128, 0, 128, 50)
			client_print(id, print_chat, "%s You now have starmie's recover! Keydown to recieve health!",PLUGNAME)
		}
		case 2:
		{
			Pokemon[id] = POLIWHIRL
			screenflash(id, 0, 0, 255, 50)
			client_print(id, print_chat, "%s You now have poliwhirl's confusion! Keydown and enemies look the other way!",PLUGNAME)
		}
		case 8: pokedex(id)
		case 9: TypeMenu(id)
	}
	bind_hud(id, 1)
	SetSpeed(id)
	return PLUGIN_HANDLED
 }
 //--ElectricMenu--//
 public ElectricMenu(id)
 {
	new menuBody[1024]

	format(menuBody, 1023, "\rElectric Pokemon:^n^n \w1.  \yPikachu\R\wQuick Attack^n 2.  \yVoltorb\R\wSelf-Destruct^n 3.  \yElectrabuzz\R\wFlash^n^n9. Pokedex^n0. Cancel")

	show_menu(id, allkeys, menuBody)
 }
 public ElectricChoices(id, key)
 {
	switch(key)
	{
		case 0:
		{
			Pokemon[id] = PIKACHU
			screenflash(id, 250, 250, 10, 50)
			client_print(id, print_chat, "%s You now have pikachu's quick attack! Do double damage!",PLUGNAME)
		}
		case 1:
		{
			Pokemon[id] = VOLTORB
			screenflash(id, 250, 250, 10, 50)
			client_print(id, print_chat, "%s You now have voltorb's self-destruct! Blow up when you die!",PLUGNAME)
		}
		case 2:
		{
			Pokemon[id] = ELECTRABUZZ
			screenflash(id, 250, 250, 10, 50)
			client_print(id, print_chat, "%s You now have electrabuzz's flash! Chance of hitting someone with a flash bullet!",PLUGNAME)
		}
		case 8: pokedex(id)
		case 9: TypeMenu(id)
	}
	bind_hud(id, 1)
	SetSpeed(id)
	return PLUGIN_HANDLED
 }
 //--RockMenu--//
 public RockMenu(id)
 {
	new menuBody[1024]

	format(menuBody, 1023, "\rRock Pokemon:^n^n \w1.  \yGeodude\R\wHarden^n 2.  \yOnix\R\wRock Throw^n 3.  \yAerodactyl\R\wAgility^n^n9. Pokedex^n0. Cancel")

	show_menu(id, allkeys, menuBody)
 }
 public RockChoices(id, key)
 {
	switch(key)
	{
		case 0:
		{
			Pokemon[id] = GEODUDE
			screenflash(id, 128, 128, 128, 50)
			client_print(id, print_chat, "%s You now have geodude's harden! Keydown to swap half of you armor for health!",PLUGNAME)
		}
		case 1:
		{
			Pokemon[id] = ONIX
			screenflash(id, 226, 226, 226, 50)
			client_print(id, print_chat, "%s You now have onix's rock throw! Start throwing those boulders!",PLUGNAME)
		}
		case 2:
		{
			Pokemon[id] = AERODACTYL
			screenflash(id, 139, 59, 19, 50)
			client_print(id, print_chat, "%s You now have aerodactyl's agility! Run faster than others!",PLUGNAME)
		}
		case 8: pokedex(id)
		case 9: TypeMenu(id)
	}
	bind_hud(id, 1)
	SetSpeed(id)
	return PLUGIN_HANDLED
 }
 //--PsychicMenu--//
 public PsychicMenu(id)
 {
	new menuBody[1024]

	format(menuBody, 1023, "\rPsychic Pokemon:^n^n \w1.  \yAbra\R\wTeleport^n 2.  \yKadabra\R\wPsybeam^n 3.  \yAlakazam\R\wReflect^n^n9. Pokedex^n0. Cancel")

	show_menu(id, allkeys, menuBody)
 }
 public PsychicChoices(id, key)
 {
	switch(key)
	{
		case 0:
		{
			Pokemon[id] = ABRA
			screenflash(id, 255, 0, 255, 50)
			client_print(id, print_chat, "%s You now have abra's teleport! Teleport to where your aiming!",PLUGNAME)
		}
		case 1:
		{
			Pokemon[id] = KADABRA
			screenflash(id, 255, 0, 255, 50)
			client_print(id, print_chat, "%s You now have kadabra's psybeam! Shoot a powerful beam of energy!",PLUGNAME)
		}
		case 2:
		{
			Pokemon[id] = ALAKAZAM
			screenflash(id, 255, 0, 255, 50)
			client_print(id, print_chat, "%s You now have alakazam's reflect! Chance of making a bullet go back at an enemy!",PLUGNAME)
		}
		case 8: pokedex2(id)
		case 9: Type2Menu(id)
	}
	bind_hud(id, 1)
	SetSpeed(id)
	return PLUGIN_HANDLED
 }
 //--BugMenu--//
 public BugMenu(id)
 {
	new menuBody[1024]

	format(menuBody, 1023, "\rBug Pokemon:^n^n \w1.  \yCaterpie\R\wString Shot^n 2.  \yVenonat\R\wSleep Powder^n 3.  \yPinsir\R\wSlash^n^n9. Pokedex^n0. Cancel")

	show_menu(id, allkeys, menuBody)
 }
 public BugChoices(id, key)
 {
	switch(key)
	{
		case 0:
		{
			Pokemon[id] = CATERPIE
			screenflash(id, 0, 28, 0, 50)
			client_print(id, print_chat, "%s You now have caterpie's string shot! Shoot people to make them slow!",PLUGNAME)
		}
		case 1:
		{
			Pokemon[id] = VENONAT
			screenflash(id, 0, 128, 0, 50)
			client_print(id, print_chat, "%s You now have venonat's sleep powder! Leave powder that makes enemies fall asleep!",PLUGNAME)
		}
		case 2:
		{
			Pokemon[id] = PINSIR
			screenflash(id, 139, 59, 19, 50)
			client_print(id, print_chat, "%s You now have pinsir's slash! Lunge forward with your knife and deal more damage!",PLUGNAME)
		}
		case 8: pokedex2(id)
		case 9: Type2Menu(id)
	}
	bind_hud(id, 1)
	SetSpeed(id)
	return PLUGIN_HANDLED
 }
 //--PoisonMenu--//
 public PoisonMenu(id)
 {
	new menuBody[1024]

	format(menuBody, 1023, "\rPoison Pokemon:^n^n \w1.  \yArbok\R\wPoison Sting^n 2.  \yWeezing\R\wToxic^n 3.  \yZubat\R\wBite^n^n9. Pokedex^n0. Cancel")

	show_menu(id, allkeys, menuBody)
 }
 public PoisonChoices(id, key)
 {
	switch(key)
	{
		case 0:
		{
			Pokemon[id] = ARBOK
			screenflash(id, 128, 0, 128, 50)
			client_print(id, print_chat, "%s You now have arbok's poison sting! Poison attackers!",PLUGNAME)
		}
		case 1:
		{
			Pokemon[id] = WEEZING
			screenflash(id, 128, 0, 128, 50)
			client_print(id, print_chat, "%s You now have weezing's toxic! Leave toxic gases where you walk!",PLUGNAME)
		}
		case 2:
		{
			Pokemon[id] = ZUBAT
			screenflash(id, 108, 0, 108, 50)
			client_print(id, print_chat, "%s You now have zubat's bite! Touch players to bite them!",PLUGNAME)
		}
		case 8: pokedex2(id)
		case 9: Type2Menu(id)
	}
	bind_hud(id, 1)
	SetSpeed(id)
	return PLUGIN_HANDLED
 }
 //--GhostMenu--//
 public GhostMenu(id)
 {
	new menuBody[1024]

	format(menuBody, 1023, "\rGhost Pokemon:^n^n \w1.  \yGastly\R\wNight Shade^n 2.  \yHaunter\R\wHypnosis/Dream Eater^n 3.  \yGengar\R\wConfuse Ray^n^n9. Pokedex^n0. Cancel")

	show_menu(id, allkeys, menuBody)
}
 public GhostChoices(id, key)
 {
	switch(key)
	{
		case 0:
		{
			Pokemon[id] = GASTLY
			screenflash(id, 28, 0, 28, 50)
			client_print(id, print_chat, "%s You now have gastly's night shade! Fade in and out of sight!",PLUGNAME)
		}
		case 1:
		{
			Pokemon[id] = HAUNTER
			screenflash(id, 128, 0, 128, 50)
			client_print(id, print_chat, "%s You now have haunter's hypnosis and dream eater! Make players sleep and eat their dreams!",PLUGNAME)
		}
		case 2:
		{
			Pokemon[id] = GENGAR
			screenflash(id, 108, 0, 108, 50)
			client_print(id, print_chat, "%s You now have gengar's confuse ray! Randomly remove 2 hitzones!",PLUGNAME)
		}
		case 8: pokedex2(id)
		case 9: Type2Menu(id)
	}
	bind_hud(id, 1)
	SetSpeed(id)
	return PLUGIN_HANDLED
 }
 //--NormalMenu--//
 public NormalMenu(id)
 {
	new menuBody[1024]

	format(menuBody, 1023, "\rNormal Pokemon:^n^n \w1.  \yPidgey\R\wFly^n 2.  \yMeowth\R\wPayDay^n 3.  \yChansey\R\wEgg Bomb^n 4.  \yDoduo\R\wDouble Edge^n 5.  \yPorygon\R\wConversion^n 6.  \ySnorlax\R\wRest^n^n9. Pokedex^n0. Cancel")

	show_menu(id, allkeys, menuBody)
 }
 public NormalChoices(id, key)
 {
	switch(key)
	{
		case 0:
		{
			Pokemon[id] = PIDGEY
			screenflash(id, 255, 255, 255, 50)
			client_print(id, print_chat, "%s You now have pidgey's fly! Jump to flap your wings!",PLUGNAME)
		}
		case 1:
		{
			Pokemon[id] = MEOWTH
			screenflash(id, 255, 255, 255, 50)
			client_print(id, print_chat, "%s You now have meowth's payday! Recieve money for damage done by your team!",PLUGNAME)
		}
		case 2:
		{
			Pokemon[id] = CHANSEY
			screenflash(id, 255, 255, 255, 50)
			client_print(id, print_chat, "%s You now have chansey's egg bomb! Get extra grenades that explode on keydown!",PLUGNAME)
		}
		case 3:
		{
			Pokemon[id] = DODUO
			screenflash(id, 255, 255, 255, 50)
			client_print(id, print_chat, "%s You now have doduo's double edge! Get double ammo when you kill an enemy!",PLUGNAME)
		}
		case 4:
		{
			Pokemon[id] = PORYGON
			screenflash(id, 255, 255, 255, 50)
			client_print(id, print_chat, "%s You now have porygon's conversion! Convert to the enemies pokemon type!",PLUGNAME)
		}
		case 5:
		{
			Pokemon[id] = SNORLAX
			screenflash(id, 255, 255, 255, 50)
			client_print(id, print_chat, "%s You now have snorlax's rest! Crouch to fall asleep and regain HP!",PLUGNAME)
		}
		case 8: pokedex2(id)
		case 9: Type2Menu(id)
	}
	bind_hud(id, 1)
	SetSpeed(id)
	return PLUGIN_HANDLED
 }
 //--TypeMenu--//
 public TypeMenu(id)
 {
	new menuBody[1024]

	format(menuBody, 1023, "\rPokemon Types:\R\w(1/2)^n^n\w1.  \yGrass Pokemon^n\w2.  \yFire Pokemon^n\w3.  \yWater Pokemon^n\w4.  \yElectric Pokemon^n\w5.  \yRock Pokemon^n^n\w6.  \yMore Pokemon^n^n\w9.  Pokedex^n0.  Cancel")

	show_menu(id, allkeys, menuBody)
 }
 public TypeChoices(id, key)
 {
	switch(key)
	{
		case 0: GrassMenu(id)
		case 1: FireMenu(id)
		case 2: WaterMenu(id)
		case 3: ElectricMenu(id)
		case 4: RockMenu(id)
		case 5: Type2Menu(id)
		case 8: pokedex(id)
		case 9: return PLUGIN_CONTINUE
	}
	return PLUGIN_HANDLED
 }
 //--Type2Menu--//
 public Type2Menu(id)
 {
	new menuBody[1024]

	format(menuBody, 1023, "\rPokemon Types:\R\w(2/2)^n^n\w1.  \yPsychic Pokemon^n\w2.  \yBug Pokemon^n\w3.  \yPoison Pokemon^n\w4.  \yGhost Pokemon^n\w5.  \yNormal Pokemon^n^n\w6.  \yMore Pokemon^n^n\w9.  Pokedex^n0.  Cancel")

	show_menu(id, allkeys, menuBody)
 }
 public Type2Choices(id, key)
 {
	switch(key)
	{
		case 0: PsychicMenu(id)
		case 1: BugMenu(id)
		case 2: PoisonMenu(id)
		case 3: GhostMenu(id)
		case 4: NormalMenu(id)
		case 5: TypeMenu(id)
		case 8: pokedex2(id)
		case 9: return PLUGIN_CONTINUE
	}
	return PLUGIN_HANDLED
 }
 //--PokeMenu--//
 public PokeMenu(id)
 {
		new menuBody[1024], iLen

		iLen += format(menuBody[iLen], (1023-iLen), "\rPoke Center:^n^n\w1.  Pokemon^n2.  PokeMart")
		if(get_pcvar_num(pm_oakheal)>0)
			iLen += format(menuBody[iLen], (1023-iLen), "^n3.  Heal")
		iLen += format(menuBody[iLen], (1023-iLen), "^n^n7.  Pokedex^n8.  Pokedex2^n^n9.  PokeHelp^n0.  Cancel")

		show_menu(id, allkeys, menuBody)
 }
 public MenuChoices(id, key)
 {
	switch(key)
	{
		case 0: { 
			Pokemon[id] = 0
			TypeMenu(id)
			ResetSkills(id)
		}
		case 1: ShopMenu(id)
		case 2: {
			if(get_pcvar_num(pm_oakheal)==0)
				return PLUGIN_HANDLED

			new Float:dist, pokedist = get_pcvar_num(pm_pokecenter)

			dist = Float:entity_range(id,PCent[1])
			if(dist>pokedist) dist = Float:entity_range(id,PCent[2])

			if(dist>pokedist){
				client_print(id, print_chat, "Prof. Oak: You are too far away.")
				return PLUGIN_CONTINUE
			}
			if(g_isRiding[id]){
				client_print(id, print_chat,"%s Sorry, but you can't be healed on a bicycle.",PLUGNAME)
				return PLUGIN_CONTINUE
			}
			emit_sound(id, CHAN_WEAPON, "pokemon/pokecenter.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
			g_isStopped[id] = true
			SetSpeed(id)
			set_task(2.0,"finish_heal", id)
		}
		case 6: pokedex(id)
		case 7: pokedex2(id)
		case 8: pokehelp(id)
		case 9: return PLUGIN_CONTINUE
	}
	return PLUGIN_HANDLED
 }
 //--ShopMenu--//
 public ShopMenu(id)
 {
	if (BuyCheck(id))
	{
		new menuBody[1024], iLen, enabled[10], i, iname[25]

		iLen += format(menuBody[iLen], (1023-iLen), "\rPoke Mart:^n")

		get_pcvar_string(pm_items, enabled, 9)
		if(containi(enabled, "a") != -1 ){
			i = 0
			ItemToName(i, iname)
			iLen += format(menuBody[iLen], (1023-iLen), "^n\w%d.  %s\R%d",i+1,iname, CostArray[i])
		}
		if(containi(enabled, "b") != -1 ){
			i = 1
			ItemToName(i, iname)
			iLen += format(menuBody[iLen], (1023-iLen), "^n\w%d.  %s\R%d",i+1,iname, CostArray[i])
		}
		if(containi(enabled, "c") != -1 ){
			i = 2
			ItemToName(i, iname)
			iLen += format(menuBody[iLen], (1023-iLen), "^n\w%d.  %s\R%d",i+1,iname, CostArray[i])
		}
		if(containi(enabled, "d") != -1 ){
			i = 3
			ItemToName(i, iname)
			iLen += format(menuBody[iLen], (1023-iLen), "^n\w%d.  %s\R%d",i+1,iname, CostArray[i])
		}
		if(containi(enabled, "e") != -1 ){
			i = 4
			ItemToName(i, iname)
			iLen += format(menuBody[iLen], (1023-iLen), "^n\w%d.  %s\R%d",i+1,iname, CostArray[i])
		}
		if(containi(enabled, "f") != -1 ){
			i = 5
			ItemToName(i, iname)
			iLen += format(menuBody[iLen], (1023-iLen), "^n\w%d.  %s\R%d",i+1,iname, CostArray[i])
		}
		if(containi(enabled, "g") != -1 ){
			i = 6
			ItemToName(i, iname)
			iLen += format(menuBody[iLen], (1023-iLen), "^n\w%d.  %s\R%d",i+1,iname, CostArray[i])
		}
		if(containi(enabled, "h") != -1 ){
			i = 7
			ItemToName(i, iname)
			iLen += format(menuBody[iLen], (1023-iLen), "^n\w%d.  %s\R%d",i+1,iname, CostArray[i])
		}
		if(containi(enabled, "i") != -1 ){
			i = 8
			ItemToName(i, iname)
			iLen += format(menuBody[iLen], (1023-iLen), "^n\w%d.  %s\R%d",i+1,iname, CostArray[i])
		}

		iLen += format(menuBody[iLen], (1023-iLen), "^n^n0.  Cancel")

		show_menu(id, allkeys, menuBody)
	}
 }
 public ShopChoices(id, key)
 {
	new enabled[10]
	get_pcvar_string(pm_items, enabled, 9)

	if(key==0 && !(containi(enabled, "a") != -1 )){
		return PLUGIN_CONTINUE
	}
	if(key==1 && !(containi(enabled, "b") != -1 )){
		return PLUGIN_CONTINUE
	}
	if(key==2 && !(containi(enabled, "c") != -1 )){
		return PLUGIN_CONTINUE
	}
	if(key==3 && !(containi(enabled, "d") != -1 )){
		return PLUGIN_CONTINUE
	}
	if(key==4 && !(containi(enabled, "e") != -1 )){
		return PLUGIN_CONTINUE
	}
	if(key==5 && !(containi(enabled, "f") != -1 )){
		return PLUGIN_CONTINUE
	}
	if(key==6 && !(containi(enabled, "g") != -1 )){
		return PLUGIN_CONTINUE
	}
	if(key==7 && !(containi(enabled, "h") != -1 )){
		return PLUGIN_CONTINUE
	}
	if(key==8 && !(containi(enabled, "i") != -1 )){
		return PLUGIN_CONTINUE
	}

	switch(key)
	{
		case 9: return PLUGIN_CONTINUE
		default:{
			if(BuyCheck(id)){
				new parm[2]
				parm[0] = id
				parm[1] = key
				set_task(0.1, "buy_item",0, parm, 2)
			}
		}
	}
	return PLUGIN_HANDLED
 }
 //--ItemUseMenu--//
 public ItemUseMenu(id)
 {
	if (is_user_alive(id))
	{
		if(PokeItem(id))
		{
			new menuBody[1024], iname[25]
			new iLen = format(menuBody, 1023, "\rYour Items:^n")

			for(new num = 0; num<9; num++)
			{
				if(HasPokeItem(id,num)){
					ItemToName(num,iname)
					iLen += format(menuBody[iLen], (1023-iLen), "^n\w%d.  \y%s (%d)",num+1,iname, Item[id][num])
				}
			}

			iLen += format(menuBody[iLen], (1023-iLen), "^n^n0. Cancel")
			show_menu(id, allkeys, menuBody)
		}
		else
			ShopMenu(id)
	}
	return PLUGIN_HANDLED
 }
 public ItemUseChoices(id, key)
 {
	switch(key)
	{
		case 9: UseItem(id,key)
		default:{
			if(HasPokeItem(id,key))
				UseItem(id,key)
			else UseItem(id,9)
		}
	}
	return PLUGIN_HANDLED
 }

 //--Stuff for the pokemart--//
 public BuyCheck(id)
 {
	if(is_user_alive(id) && PMon()){
		if(cs_get_user_buyzone(id))
			return 1
		new Float:dist, pokedist = get_pcvar_num(pm_pokecenter)

		dist = Float:entity_range(id,PCent[1])
		if(dist>pokedist) dist = Float:entity_range(id,PCent[2])

		if(dist<pokedist){
			return 1
		}
	}
	return 0
 }

 //--Item Stuff--//
 public buy_item(parm[])
 {
	new cost, money, id = parm[0], num = parm[1], iname[25], amount = 0, price = 0
	new random = random_num(1,100)

	if(!is_user_alive(id) || !PMon()) return PLUGIN_HANDLED

	ItemToName(num, iname)
	
	cost = CostArray[num]
	money = cs_get_user_money(id)

	if(num==7 && HasPokeItem(id,7)){//only one bike please
		client_print(id, print_chat,"%s Sorry, but you can only have one bicycle.",PLUGNAME)
		return PLUGIN_HANDLED
	}
	if(money < cost){//costs too much
		client_print(id, print_center,"You have insufficient funds!")
		return PLUGIN_HANDLED
	}
	if( random < 76 || num==7 || money < 2*cost){//buyone
		amount = 1
		price = 1
	}
	else{//theres a deal
		if(random < 91 || money < 3*cost){//just normal deal 3 for price of 2
			amount = 3
			price = 2
		}
		else{//super deal 5 for the price of 3
			amount = 5
			price = 3
		}
	}
	if(is_user_bot(id)){
		BotSay(id, 1, amount, num)
		if(num==7)
			g_isRiding[id] = true
	}

	Item[id][num] += amount
	cs_set_user_money(id, money - (cost*price))

	if(price==1)
		client_print(id, print_chat,"%s You bought %d %s.",PLUGNAME, price, iname)
	else
		client_print(id, print_chat,"%s You bought %d %ss for the price of %d!",PLUGNAME, amount, iname, price)

	if(num==8){
		maxhp[id] += 100*amount
		CheckMaxHP(id)
		Heal(id, 100*amount)
	}

	return PLUGIN_HANDLED
 }
 public UseItem(id, item)
 {
	if(!is_user_alive(id) || !PMon()) return PLUGIN_HANDLED

	//check turns into 1 if item is used, and 2 if soundcure should be played
	new check = 0

	switch(item){
		case 9: {
			return PLUGIN_HANDLED
		}
		case 0: {
			check = 2
			Heal(id, 20)
			client_print(id,print_chat,"%s You used a Potion!",PLUGNAME)
		}
		case 1: {
			if(cpois[id]){
				check = 2
				cpois[id] = 0
				client_print(id,print_chat,"%s You used an Antidote!",PLUGNAME)
				}
			else{
				client_print(id,print_chat,"%s You are not poisoned.",PLUGNAME)
				sounddeny(id)
			}
		}
		case 2: {
			new dist = floatround(get_pcvar_num(pm_pokecenter)*2.5)
			if(entity_range(id,PCent[1]) < dist || entity_range(id,PCent[2]) < dist){
				client_print(id,print_chat,"%s You are too close to a PokeCenter.",PLUGNAME)
				sounddeny(id)
				return PLUGIN_HANDLED
			}
			check = 1
			EscapeRope(id, 1)
			client_print(id,print_chat,"%s You used an Escape Rope!",PLUGNAME)
			if(is_user_bot(id))
				MenuChoices(id, 2)
		}
		case 3: {
			if(cpois[id] || g_isAsleep[id] || g_isLeeched[id] || g_isBurning[id]){
				check = 2
				ResetStatus(id)
				client_print(id,print_chat,"%s You used a Full Heal!",PLUGNAME)
			}
			else client_print(id,print_chat,"%s You do not have any status effects.",PLUGNAME)
		}
		case 4: {
			check = 2
			Heal(id, 70)
			client_print(id,print_chat,"%s You used a Super Potion!",PLUGNAME)
		}
		case 5: {
			check = 2
			Heal(id, 70)
			client_print(id,print_chat,"%s You used a Hyper Potion!",PLUGNAME)
		}
		case 6: {
			check = 2
			ResetStatus(id)
			set_user_health(id, maxhp[id])
			client_print(id,print_chat,"%s You used a Full Restore!",PLUGNAME)
		}
		case 7: {
			if(g_isRiding[id]){
				g_isRiding[id] = false
				client_print(id,print_chat,"%s You stopped riding your bicycle!",PLUGNAME)
			}
			else{
				g_isRiding[id] = true
				client_print(id,print_chat,"%s You started riding your bicycle!",PLUGNAME)
			}
			SetSpeed(id)
		}
		case 8:
			client_print(id,print_chat,"%s HP Ups are used automatically.",PLUGNAME)
		default: sounddeny(id)
	}

	if(check > 0)
		Item[id][item] -= 1
	if(check==2)
		soundcure(id)

	return PLUGIN_HANDLED
 }

 
 //--returns if they have an item--//
 PokeItem(id)
 {
	if(!PMon()) return false

	for(new i = 0; i < 9; i++){
		if(Item[id][i] > 0)
			return true
	}
	return false
 }
 //--determines if id has this item--//
 HasPokeItem(id, item)
 {
	if(!PMon()) return false

	if(Item[id][item] > 0)
		return true
	return false
 }
 public EscapeRope(id, num)
 {
	new entSpawn
	new Float:spawnAngle[3] 
	new Float:spawnOrigin[3]

	if(num > 0)
		if(!PassTest(id, 0))
			return PLUGIN_HANDLED

	for(new i=0 ; i < MAX_PLAYERS+1 ; i++){
		spawnPointsused[i] = false
	}

	if(is_valid_ent(id)){
		new teamnum = 0
		if(is_user_alive(id))
			teamnum = Team(id)
		else if(id==PCent[1])
			teamnum = 1
		else if(id==PCent[2])
			teamnum = 2
		if(teamnum!=0)
			entSpawn = find_free_spawn(id, teamnum, spawnOrigin, spawnAngle)
	}

	if (!entSpawn) 
	{
		// Didn't find a free spawn spot. Quit... 
		if(is_user_alive(id))
			client_print(id,print_chat,"%s You couldn't find a way out.",PLUGNAME)
		return PLUGIN_CONTINUE 
	}

	new origina[3]
	FVecIVec(spawnOrigin, origina)

	if(num>0){
		get_user_origin(id, origin[id])

		message_begin(MSG_BROADCAST ,SVC_TEMPENTITY) //message begin
		write_byte(0)
		write_coord(origin[id][0]) // start position
		write_coord(origin[id][1])
		write_coord(origin[id][2])
		write_coord(origina[0]) // end position
		write_coord(origina[1])
		write_coord(origina[2])
		write_short(rope) // sprite index
		write_byte(0) // starting frame
		write_byte(0) // frame rate in 0.1's
		write_byte(20) // life in 0.1's
		write_byte(7) // line width in 0.1's
		write_byte(0) // noise amplitude in 0.01's
		write_byte(139) // Red
		write_byte(59) // Green
		write_byte(19) // Blue
		write_byte(255) // brightness)
		write_byte(0) // scroll speed in 0.1's
		message_end()
	}

	entity_set_vector(id, EV_VEC_angles, spawnAngle)
	set_user_origin(id,origina)

	return PLUGIN_HANDLED
 }
 //////////////////////////////////////////////////////
 //--The pokemon skills that require pressing a key--//
 //     this is also seperated into pokemon types    //
 //////////////////////////////////////////////////////
 ///////////////////
 // Grass Pokemon //
 ///////////////////
 public Bulbasaur_keydown(id)
 {
	new abody, aid, parm[2]
	parm[0] = id
	get_user_aiming(id, aid, abody)
	bind_hud(id, 2)

	if ( is_user_alive(aid) ){
		if (!g_isLeeched[aid]){
			g_isLeeched[aid] = true
			parm[1] = aid
			set_task(0.1, "bulbasaur_loop",0, parm, 2)
			set_task(get_pcvar_float(pm_bulbtime), "bind_status", id )
		}
		else client_print(id, print_chat, "%s The enemy is already being leeched and is not effected!",PLUGNAME)
	}
 }
 public bulbasaur_loop(parm[])
 {
	new id = parm[0], aid = parm[1]
	new aliveI = is_user_alive(id), aliveA = is_user_alive(aid)

	if(!aliveI || !aliveA || !g_isLeeched[aid]) return

	new aName[32], iName[32], dmg = get_pcvar_num(pm_leech)

	soundhit(id)
	soundhit(aid)

	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(8)		// TE_BEAMENTS
	write_short(id)		// Start Entity
	write_short(aid)		// End Entity
	write_short(rope)		// Sprite Index
	write_byte(1)		// Starting Frame
	write_byte(1)		// Frame Rate in 0.1's
	write_byte(10)		// Life in 0.1's
	write_byte(5)		// Line width in 0.1's
	write_byte(0)		// Noise amplitude in 0.01's
	write_byte(0)		// Red
	write_byte(255)		// Green
	write_byte(0)		// Blue
	write_byte(100)		// Brightness
	write_byte(0)		// Scroll speed in 0.1's
	message_end()

	get_user_name(id, iName, 31)
	get_user_name(aid, aName, 31)

	client_print(id,print_center,"You have leeched %s", aName)
	client_print(aid,print_center,"You have been leeched by %s", iName)

	screenflash(id, 0, 255, 0, 50)
	screenflash(aid, 0, 255, 0, 50)

	Heal(id, dmg)
	pokedamage(aid, id, dmg, "Leech Seed")

	new Float:tasktime = 5.0

	if( aliveI && aliveA && g_isLeeched[aid]) set_task(tasktime, "bulbasaur_loop",0, parm, 2)
	else g_isLeeched[aid] = false
 }
 public Bellsprout_keydown(id)
 {
	new body, aid
	get_user_aiming(id, aid, body)

	if(is_user_alive(aid)){
		new Float:velocity[3]
		new Float:jump = get_pcvar_float(pm_whip)
		new whipdamage = get_pcvar_num(pm_whipdamage)

		bind_hud(id, 2)
		get_user_origin(id, origin[id])
		
		pokedamage( aid, id, whipdamage, "Vine Whip")

		soundhit(id)
		soundhit(aid)

		message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
		write_byte(8)		// TE_BEAMENTS
		write_short(id)		// Start Entity
		write_short(aid)		// End Entity
		write_short(rope)		// Sprite Index
		write_byte(1)		// Starting Frame
		write_byte(1)		// Frame Rate in 0.1's
		write_byte(10)		// Life in 0.1's
		write_byte(5)		// Line width in 0.1's
		write_byte(5)		// Noise amplitude in 0.01's
		write_byte(0)		// Red
		write_byte(255)		// Green
		write_byte(0)		// Blue
		write_byte(100)		// Brightness
		write_byte(0)		// Scroll speed in 0.1's
		message_end()

		entity_get_vector(id,EV_VEC_velocity,velocity)

		velocity[2] += jump

		entity_set_vector(aid,EV_VEC_velocity,velocity)
		entity_set_int(aid, EV_INT_gaitsequence, 6)

		set_task(get_pcvar_float(pm_bellstime), "bind_status", id )
	}
	else sounddeny(id)
 }
 ///////////////////
 // Fire Pokemon //
 ///////////////////
 public Growlithe_keydown(id)
 {
	if ( entity_get_int(id, EV_INT_waterlevel) == 3 ){
		client_print(id, print_chat, "%s You cannot use Flame Thrower while underwater",PLUGNAME)
		sounddeny(id)
		return
	}
	bind_hud(id, 2)
	set_task(1.0 , "bind_status", id )
	
	new flamecount = 3

	new Float:fOrigin[3], Float:fVelocity[3]
	entity_get_vector(id,EV_VEC_origin, fOrigin)
	VelocityByAim(id, 35, fVelocity)
	
	new Float:fTemp[3], iFireOrigin[3]
	xs_vec_add(fOrigin, fVelocity, fTemp)
	FVecIVec(fTemp, iFireOrigin)

	new Float:fFireVelocity[3], iFireVelocity[3]
	VelocityByAim(id, 100, fFireVelocity)
	FVecIVec(fFireVelocity, iFireVelocity)

	new parm[7]
	parm[0] = iFireOrigin[0]
	parm[1] = iFireOrigin[1]
	parm[2] = iFireOrigin[2]
	parm[3] = iFireVelocity[0]
	parm[4] = iFireVelocity[1]
	parm[5] = iFireVelocity[2]
	parm[6] = explode1

	set_task(0.1, "create_flames", 0, parm, 7, "a", flamecount)
	emit_sound(id, CHAN_WEAPON, "ambience/flameburst1.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)

	parm[0] = id
	parm[1] = 1
	set_task(0.1, "flame_check", 0, parm, 2, "a", flamecount)
 }

 public create_flames(parm[])
 {
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(120)
	write_coord(parm[0])		//origin
	write_coord(parm[1])
	write_coord(parm[2])
	write_coord(parm[3])		//velocity
	write_coord(parm[4])
	write_coord(parm[5] + 5)
	write_short(parm[6])		//sprite
	write_byte(8)				//count
	write_byte(10)				//speed
	write_byte(100)				//noise
	write_byte(5)				//rendermode
	message_end()
 }
 public flame_check(parm[])
 {
	new id = parm[0]
	new flame = parm[1]	//this is 0 for smoke, 1 for fire

	//direct damage first
	new ent, body
	get_user_aiming(id, ent, body, 600)
	
	if(is_user_alive(ent))
	{
		if(flame==1)
			burn_victim(ent, id)
		else
			screenflash(ent,255,255,255,255)
	}

	//now indirect damage
	new Players[32], iNum, target
	get_players(Players, iNum, "a")
	for(new i = 0; i < iNum; ++i)
	{
		target = Players[i]
		if(target==id)
			continue

		new Float:fOrigin[3], Float:fOrigin2[3]
		entity_get_vector(id,EV_VEC_origin, fOrigin)
		entity_get_vector(target, EV_VEC_origin, fOrigin2)

		new temp[3], Float:fAim[3]
		get_user_origin(id, temp, 3)
		IVecFVec(temp, fAim)
		
		new Float:fDistance = 600.0
		if(get_distance_f(fOrigin, fOrigin2) > fDistance)
			continue 

		new iDistance = get_distance_to_line(fOrigin, fOrigin2, fAim)
		if(iDistance > 40 || iDistance < 0 || !fm_is_ent_visible(id, target))
			continue 
			
		if(flame==1)
			burn_victim(target, id)
		else
			screenflash(target,255,255,255,255)
	}
 }
 public burn_victim(id, killer)
 {
	if ( entity_get_int(id, EV_INT_waterlevel) == 3 ) return
	if ( g_isBurning[id] ) return
	if(Team(id)==Team(killer)) return

	g_isBurning[id] = true

	emit_sound(id, CHAN_ITEM, "ambience/burning1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)

	new args[2]
	args[0] = id
	args[1] = killer
	set_task(0.5, "on_fire", 0, args, 2, "a", 10)
	set_task(5.5, "stopFireSound", id)
 }
 public on_fire(args[])
 {
	new id = args[0]
	new killer = args[1]

	if( !is_user_connected(id) || !is_user_alive(id) )
	{
		g_isBurning[id] = false
		return
	}

	if( entity_get_int( id, EV_INT_waterlevel ) == 3 )
	{
		g_isBurning[id] = false
		return
	}

	if ( !g_isBurning[id] ) return

	new forigin[3]
	get_user_origin(id, forigin)

	// Additive sprite, plays 1 cycle
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(17)				// TE_SPRITE
	write_coord(forigin[0])	// coord, coord, coord (position)
	write_coord(forigin[1])
	write_coord(forigin[2]+10)
	write_short(xfire)	// short (sprite index)
	write_byte(30)		// byte (scale in 0.1's)
	write_byte(200)	// byte (brightness)
	message_end()

	// Smoke
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY)
	write_byte(5)					// TE_SMOKE
	write_coord(forigin[0])	// coord, coord, coord (position)
	write_coord(forigin[1])
	write_coord(forigin[2]+100)
	write_short(steam1)		// short (sprite index)
	write_byte(60)		// byte (scale in 0.1's)
	write_byte(15)		// byte (framerate)
	message_end()

	new damage = get_pcvar_num(pm_burndamage)
	new finalhp = Health(id) - damage
	new Attack[] = "Flame Thrower"

	if ( finalhp <= 0 )
	{
		pokedamage(id, killer, damage, Attack)
	}
	else
	{
		set_user_health(id, finalhp)
		logDmg(killer, id, Attack,"body",damage,finalhp)
	}
 }
 public stopFireSound(id)
 {
	new sndStop = (1<<5)
	g_isBurning[id] = false
	emit_sound(id, CHAN_ITEM, "ambience/burning1.wav", 1.0, ATTN_NORM, sndStop, PITCH_NORM)
 }
 public Magmar_keydown(id)
 {
	new smokecount = 3
	bind_hud(id, 2)
	set_task(1.0 , "bind_status", id )

	new Float:fOrigin[3], Float:fVelocity[3]
	entity_get_vector(id,EV_VEC_origin, fOrigin)
	VelocityByAim(id, 35, fVelocity)
	
	new Float:fTemp[3], iFireOrigin[3]
	xs_vec_add(fOrigin, fVelocity, fTemp)
	FVecIVec(fTemp, iFireOrigin)

	new Float:fFireVelocity[3], iFireVelocity[3]
	VelocityByAim(id, 100, fFireVelocity)
	FVecIVec(fFireVelocity, iFireVelocity)

	new parm[7]
	parm[0] = iFireOrigin[0]
	parm[1] = iFireOrigin[1]
	parm[2] = iFireOrigin[2]
	parm[3] = iFireVelocity[0]
	parm[4] = iFireVelocity[1]
	parm[5] = iFireVelocity[2]
	parm[6] = ballsmoke

	set_task(0.1, "create_flames", 0, parm, 7, "a", smokecount)
	emit_sound(id, CHAN_WEAPON, "ambience/flameburst1.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)

	parm[0] = id
	parm[1] = 0
	set_task(0.1, "flame_check", 0, parm, 2, "a", smokecount)

	return PLUGIN_HANDLED
 }
 ///////////////////
 // Water Pokemon //
 ///////////////////
 public Squirtle_keydown(id)
 {
	if ( entity_get_int(id, EV_INT_waterlevel) == 3 ) bubbles[id] = get_pcvar_num(pm_bubblenum)
	bind_hud(id, 2)
	if(bubbles[id] > 0){

		new bubnum, abody, aid, aimvec[3]
		get_user_origin(id, origin[id])
		get_user_origin(id, aimvec, 2)
		bubnum = get_distance(origin[id], aimvec)/15
		get_user_aiming(id, aid, abody)

		emit_sound(id, CHAN_WEAPON, "player/pl_swim3.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)

		if ( entity_get_int(id, EV_INT_waterlevel) != 3 ){
			bubbles[id] -= 1
			message_begin(MSG_BROADCAST, SVC_TEMPENTITY)	//message begin
			write_byte(15)
			write_coord(origin[id][0])		// start position
			write_coord(origin[id][1])
			write_coord(origin[id][2])
			write_coord(aimvec[0])	// end position
			write_coord(aimvec[1])
			write_coord(aimvec[2])
			write_short(bubble)		// sprite index
			write_byte(bubnum/2)		// count
			write_byte(1/2)		// life in 0.1's
			write_byte(5)		// scale in 0.1's
			write_byte(5)		// velocity along vector in 10's
			write_byte(5)	// randomness of velocity in 10's
			message_end()
		}
		else {
			message_begin(MSG_BROADCAST, SVC_TEMPENTITY) //message begin
			write_byte(114)
			write_coord(origin[id][0])				// min start position
			write_coord(origin[id][1])
			write_coord(origin[id][2])
			write_coord(aimvec[0])			// max start position
			write_coord(aimvec[1])
			write_coord(aimvec[2])
			write_coord(EV_INT_waterlevel)	// float height
			write_short(bubble)				// model index
			write_byte(bubnum)					// count
			write_coord(100)				// speed
			message_end()
		}

		set_task(1.0 , "bind_status", id )

		client_print(id,print_center,"You have %d Bubble Beams", bubbles[id])

		if (is_user_alive(aid)){
			new bubdamage = get_pcvar_num(pm_bubbledamage)
			pokedamage(aid, id, bubdamage, "Bubble Beam")
			emit_sound(aid, CHAN_AUTO, "player/pl_pain7.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		}
	}
	else {
		client_print(id, print_chat, "%s You are out of Bubble Beam, go into water and keydown.",PLUGNAME)
		sounddeny(id)
	}
 }
 public Starmie_keydown(id)
 {
	new hp = Health(id), heal
 
	bind_hud(id, 2)

	soundcure(id)
	screenflash(id, 128, 0, 128, 50)

	heal = floatround((maxhp[id]-hp)*get_pcvar_float(pm_recover))

	set_user_health(id, hp+heal)

	set_task(get_pcvar_float(pm_starmietime), "bind_status", id )
 }
 public Poliwhirl_keydown(id)
 {
	soundcast(id)
	bind_hud(id, 2)
	screenflash(id, 0, 0, 255, 50)

	get_user_origin(id, origin[id])

	new aid, players[MAX_PLAYERS], pnum, applecount, Name[32]
	get_players(players,pnum,"a")
	get_user_name(id, Name, 31)

	for(new i = 0; i<pnum; i++)
	{
		aid = players[i]
		if(Team(id) != Team(aid)) {
			get_user_origin(aid, origin[aid])

			new distance = get_distance(origin[aid], origin[id])
			new maxdist = get_pcvar_num(pm_polidist)

			if(distance <= maxdist){
				new ran = random_num(1,180), Float:look[3]
			
				entity_get_vector(aid, EV_VEC_angles, look)
				if(look[0]<180) look[0] +=ran
				else look[0] -= ran
				if(look[1]<180) look[1] +=ran
				else look[1] -= ran

				entity_set_vector(aid, EV_VEC_angles, look)
				entity_set_int(aid, EV_INT_fixangle, 1)

				client_print(id, print_center, "You were confused by %s", Name)

				applecount += 1
			}
		}
	}
	if(applecount){
		set_task(get_pcvar_float(pm_politime), "bind_status", id )
		if(applecount>1)
			client_print(id, print_center, "You confused %d people", applecount)
		else
			client_print(id, print_center, "You confused someone")
	}
	else
		sounddeny(id)
 }
 //////////////////////
 // Electric Pokemon //
 //////////////////////
 //--Voltorb Stuff--//
 public BlowUp(id)
 {
	get_user_origin(id,origin[id])

	emit_sound(id,CHAN_STATIC, "ambience/particle_suck1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
	new parm[2]
	parm[0]=id
	parm[1]=6
	set_task(0.5,"apacheexplode",0,parm,2)
	set_task(0.5,"blastcircles",0,parm,2)
	set_task(1.0,"bum",0,parm,1)

	message_begin( MSG_BROADCAST, SVC_TEMPENTITY )
	write_byte(14)
	write_coord(origin[id][0])
	write_coord(origin[id][1])
	write_coord(origin[id][2])
	write_byte(100)
	write_byte(20)
	write_byte(5)
	message_end()
 }
 public apacheexplode(parm[2])
 {
	new id = parm[0]

	// random explosions
	message_begin( MSG_PVS, SVC_TEMPENTITY, origin[id] )
	write_byte(3) // This just makes a dynamic light now
	write_coord( origin[id][0] + random_num( -100, 100 ))
	write_coord( origin[id][1] + random_num( -100, 100 ))
	write_coord( origin[id][2] + random_num( -50, 50 ))
	write_short( gxplode )
	write_byte( random_num(0,20) + 20 )	// scale * 10
	write_byte( 12 )					// framerate
	write_byte(0)
	message_end()

	// lots of smoke
	message_begin( MSG_PVS, SVC_TEMPENTITY, origin[id] )
	write_byte(5)
	write_coord( origin[id][0] + random_num( -100, 100 ))
	write_coord( origin[id][1] + random_num( -100, 100 ))
	write_coord( origin[id][2] + random_num( -50, 50 ))
	write_short( steam1 )
	write_byte( 60 ) // scale * 10
	write_byte( 10 ) // framerate
	message_end()
 }
 public blastcircles(parm[2])
 {
	new id = parm[0]

	// blast circles
	message_begin( MSG_PAS, SVC_TEMPENTITY, origin[id] )
	write_byte(21)
	write_coord( origin[id][0])
	write_coord( origin[id][1])
	write_coord( origin[id][2] - 16)
	write_coord( origin[id][0])
	write_coord( origin[id][1])
	write_coord( origin[id][2] - 16 + get_pcvar_num(pm_voltorb))
	write_short( shockwave )
	write_byte( 0 )		// startframe
	write_byte( 0 )		// framerate
	write_byte( 6 )		// life
	write_byte( 16 )	// width
	write_byte( 0 )		// noise
	write_byte( 188 )
	write_byte( 220 )
	write_byte( 255 )
	write_byte( 255 )	//brightness
	write_byte( 0 )		// speed
	message_end()

	message_begin( MSG_PAS, SVC_TEMPENTITY, origin[id] )
	write_byte(21)
	write_coord( origin[id][0])
	write_coord( origin[id][1])
	write_coord( origin[id][2] - 16)
	write_coord( origin[id][0])
	write_coord( origin[id][1])
	write_coord( origin[id][2] - 16 + ( get_pcvar_num(pm_voltorb) / 2 ))
	write_short( shockwave )
	write_byte( 0 )		// startframe
	write_byte( 0 )		// framerate
	write_byte( 6 )		// life
	write_byte( 16 )	// width
	write_byte( 0 )		// noise
	write_byte( 188 )
	write_byte( 220 )
	write_byte( 255 )
	write_byte( 255 )	//brightness
	write_byte( 0 )		// speed
	message_end()

	return PLUGIN_CONTINUE
 }
 public bum(parm[2]){
	new damage, dist, Float:dRatio
	new aid = parm[0]
	new origin[3], aorigin[3]
	get_user_origin(aid,origin)

	new maxdamage = get_pcvar_num(pm_voltdamage)
	new damradius = get_pcvar_num(pm_voltorb)

	new pnum, players[MAX_PLAYERS], id
	get_players(players,pnum,"a")
	for ( new i = 0; i < pnum; i++)
	{
		id = players[i]

		get_user_origin(id,aorigin)
		dist = get_distance(origin,aorigin)
		if (dist <= damradius)
		{
			dRatio = floatdiv(float(dist),float(damradius))
			damage = maxdamage - floatround(floatmul(float(maxdamage),dRatio))
			pokedamage(id, aid, damage, "Self-Destruct")
		}
	}
 }
 ////////////////////
 // Rock Pokemon //
 ////////////////////
 public Geodude_keydown(id)
 {
	bind_hud(id, 2)
	new harden, armor = get_user_armor(id), ammount = get_pcvar_num(pm_harden)
	harden = ammount * armor / 2
	
	Heal(id, harden)
	set_user_armor(id, get_user_armor(id) / 2)

	set_task(get_pcvar_float(pm_geodudetime), "bind_status", id )
 }
 public Onix_keydown(id)
 {
	bind_hud(id, 2)
	new Float: origin[3], Float: aim[3], Float: velocity[3], Ent

	entity_get_vector(id, EV_VEC_origin, origin)
	entity_get_vector(id, EV_VEC_v_angle, aim)
	origin[2] += 20

	Ent = create_entity("info_target")

	if (!Ent) return PLUGIN_HANDLED

	entity_set_string(Ent, EV_SZ_classname, "boulder")
	entity_set_model(Ent, "models/big_rock.mdl")

	new Float:MinBox[3] = {-1.0, -1.0, -1.0}
	new Float:MaxBox[3] = {1.0, 1.0, 1.0}
	entity_set_vector(Ent, EV_VEC_mins, MinBox)
	entity_set_vector(Ent, EV_VEC_maxs, MaxBox)

	entity_set_origin(Ent, origin)
	entity_set_vector(Ent, EV_VEC_angles, aim)

	entity_set_int(Ent, EV_INT_solid, 1)
	entity_set_int(Ent, EV_INT_movetype, 10)
	entity_set_edict(Ent, EV_ENT_owner, id)

	VelocityByAim(id, 2000 , velocity)
	entity_set_vector(Ent, EV_VEC_velocity, velocity)

	emit_sound(id,CHAN_VOICE,"turret/tu_fire1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)

	set_task(get_pcvar_float(pm_onixtime), "bind_status", id )
	return PLUGIN_HANDLED
 }
 /////////////////////
 // Psychic Pokemon //
 /////////////////////
 public Abra_keydown(id)
 {
	if(PassTest(id, 1)){
		new Float:velocity[3], check[3], checkdist = 30

		get_user_origin(id, origin[id])
		get_user_origin(id, aim[id], 3)

		check[0] = origin[id][0] - aim[id][0]
		check[1] = origin[id][1] - aim[id][1]
		check[2] = origin[id][2] - aim[id][2]

		VelocityByAim(id, checkdist, velocity)

		//lets make them move back a little incase they get stuck in a wall
		if(-1*checkdist>check[0]>checkdist){
			aim[id][0] -= velocity[0]
		}
		if(-1*checkdist>check[1]>checkdist){
			aim[id][1] -= velocity[1]
		}
		if(-1*checkdist>check[2]>checkdist){
			aim[id][2] -= velocity[2]
		}

		bind_hud(id, 2)
		soundcast(id)

		message_begin(MSG_ONE,gmsgScreenFade,{0,0,0},id)
		write_short( 15 )
		write_short( 15 )
		write_short( 12 )
		write_byte( 255 )
		write_byte( 0 )
		write_byte( 255 )
		write_byte( 100 )
		message_end()

		new Float:tasktime = get_pcvar_float(pm_teletime)

		set_task(tasktime, "abra_teleport",id)
		set_task(get_pcvar_float(pm_abratime) + tasktime, "bind_status", id )
	}
	else
		sounddeny(id)

 }
 public abra_teleport(id)
 {
	get_user_origin(id, origin[id])
	set_user_origin(id, aim[id])

	message_begin(MSG_BROADCAST ,SVC_TEMPENTITY) //message begin
	write_byte(0)
	write_coord(origin[id][0]) // start position
	write_coord(origin[id][1])
	write_coord(origin[id][2])
	write_coord(aim[id][0]) // end position
	write_coord(aim[id][1])
	write_coord(aim[id][2])
	write_short(trail) // sprite index
	write_byte(0) // starting frame
	write_byte(0) // frame rate in 0.1's
	write_byte(10) // life in 0.1's
	write_byte(15) // line width in 0.1's
	write_byte(0) // noise amplitude in 0.01's
	write_byte(255) // Red
	write_byte(255) // Green
	write_byte(255) // Blue
	write_byte(255) // brightness)
	write_byte(0) // scroll speed in 0.1's
	message_end()

	screenflash(id, 0, 0, 0, 0)
	soundcast(id)

	checkCount[id] = 1
	positionChangeTimer(id)
 }
 public Kadabra_keydown(id)
 {
	if(is_valid_ent(psybeamID[id])){
		sounddeny(id)
		return
	}
	soundcast(id)
	bind_hud(id, 2)
	screenflash(id, 255, 0, 255, 100)

	new Float:fl_Origin[3], Float:fl_Angles[3], Float:fl_vAngle[3]
	new Float:VecMins[3] = {-2.0,-2.0,-2.0}
	new Float:VecMaxs[3] = {2.0,2.0,2.0}

	// Get users postion and angles (angles are probably not needed in this case)
	entity_get_vector(id, EV_VEC_origin, fl_Origin)
	entity_get_vector(id, EV_VEC_angles, fl_Angles)
	entity_get_vector(id, EV_VEC_v_angle, fl_vAngle)

	new newEnt = create_entity("info_target")

	psybeamID[id] = newEnt

	entity_set_string(newEnt, EV_SZ_classname, "psy_beam")
	entity_set_model(newEnt, "models/bleachbones.mdl")

	// Set entity size
	entity_set_vector(newEnt, EV_VEC_mins, VecMins)
	entity_set_vector(newEnt, EV_VEC_maxs, VecMaxs)

	// Change height of entity origin to hands
	fl_Origin[2] += 6

	// Set entity postion and angles
	entity_set_origin(newEnt, fl_Origin)
	entity_set_vector(newEnt, EV_VEC_angles, fl_Angles)
	entity_set_vector(newEnt, EV_VEC_v_angle, fl_vAngle)

	// Set properties of the entity
	entity_set_int(newEnt, EV_INT_solid, 2)
	entity_set_int(newEnt, EV_INT_movetype, 5)
	entity_set_int(newEnt, EV_INT_rendermode, 5)
	entity_set_float( newEnt, EV_FL_renderamt, 255.0)
	entity_set_float( newEnt, EV_FL_scale, 1.20)
	entity_set_edict(newEnt, EV_ENT_owner, id)

	new Float:Velocity[3]
	new Speed = 500

	VelocityByAim(id, Speed, Velocity)
	entity_set_vector(newEnt, EV_VEC_velocity, Velocity)

	// Pass varibles used to guide entity with
	new args[3]
	args[0] = id
	args[1] = newEnt
	args[2] = Speed

	set_task(0.1, "guide_psybeam", newEnt, args, 3)
	attach_view(id, newEnt)

	// Trail on enity. It's flawed by not being removable, so make it last long.
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
	write_byte(22)		// TE_BEAMFOLLOW
	write_short(newEnt)	// entity:attachment to follow
	write_short(trail)	// sprite index
	write_byte(50)	// life in 0.1's
	write_byte(7)		// line width in 0.1's
	write_byte(255)	//r,g,b
	write_byte(255)
	write_byte(255)
	write_byte(255)	// brightness
	message_end()
 }
 public guide_psybeam(args[])
 {
	new id = args[0]
	new entID = args[1]
	new speed = args[2]

	if ( !is_valid_ent(entID) ) return

	if ( !is_user_connected(id) || !is_user_alive(id) || Pokemon[id]!=KADABRA) {
		pfn_touch(entID, 0)
		return
	}

	new Float:Velocity[3], Float:Angles[3]
	VelocityByAim(id, speed, Velocity)
	entity_get_vector(id, EV_VEC_v_angle, Angles)
	entity_set_vector(entID, EV_VEC_velocity, Velocity)
	entity_set_vector(entID, EV_VEC_angles, Angles)

	set_task(0.1, "guide_psybeam", entID, args, 3)
 }
 /////////////////
 // Bug Pokemon //
 /////////////////
 public Venonat_keydown(id)
 {
	bind_hud(id, 2)

	new powdernum = 5

	//make one immediate
	sleep_powder(id)
	powdernum -= 1

	set_task(0.5,"sleep_powder", id, "", 0, "a", powdernum)

	set_task(get_pcvar_float(pm_venonattime) + powdernum*0.5 + get_pcvar_num(pm_powdertime), "bind_status", id )
 }
 public sleep_powder(id)
 {
	if(!PMon() || !is_user_alive(id))
		return

	new Float:fl_Origin[3], ptime = get_pcvar_num(pm_powdertime)

	entity_get_vector(id, EV_VEC_origin, fl_Origin)

	new newEnt = create_entity("info_target")

	entity_set_string(newEnt, EV_SZ_classname, "sleep_powder")
	entity_set_model(newEnt, "models/teleporter_blue_sprites.mdl")

	// Change height of entity origin to hands
	fl_Origin[2] += 6

	// Set entity postion
	entity_set_origin(newEnt, fl_Origin)

	// Set properties of the entity
	entity_set_int(newEnt, EV_INT_rendermode, 5)
	entity_set_float( newEnt, EV_FL_renderamt, 255.0)
	entity_set_float( newEnt, EV_FL_scale, 1.20)
	entity_set_edict(newEnt, EV_ENT_owner, id)
	entity_set_int(newEnt,EV_INT_sequence,0)

	check_powder(newEnt)
	set_task(0.5,"check_powder",newEnt, "", 0 , "a", 2*ptime-1)
	set_task(ptime*1.0,"poke_remove_entity",newEnt)
 }
 public check_powder(spowder)
 {
	new id = entity_get_edict(spowder, EV_ENT_owner)

	new aid, players[MAX_PLAYERS], pnum
	get_players(players,pnum,"a")

	for(new i = 0; i<pnum; i++)
	{
		aid = players[i]
		if(!g_isAsleep[aid] && Team(id)!=Team(aid)) {

			if(entity_range(spowder,aid) < 100) {
				g_isAsleep[aid] = true

				set_task(0.1, "hsleep", aid)
				set_task(get_pcvar_float(pm_sleeptime), "unsleep", aid)

				client_print(aid,print_center,"You have walked into sleep powder")
			}
		}
	}
 }
 ////////////////////
 // Poison Pokemon //
 ////////////////////
 ///////////////////
 // Ghost Pokemon //
 ///////////////////
 public Haunter_keydown(id)
 {
	new body, aid, ta
	get_user_aiming(id, aid, body)

	if(!is_user_alive(aid)) return

	if(Team(id)==Team(aid)){
		ta = 1
		if(id==aid)
			ta = 2
	}
	else
		ta = 0

	if(!g_isAsleep[aid]){
		if(Team(id)==Team(aid)) return

		soundcast(id)
		g_isAsleep[aid] = true

		set_task(0.1, "hsleep", aid)
		set_task(get_pcvar_float(pm_sleeptime), "unsleep", aid)

		client_print(id,print_center,"They are now asleep")
		client_print(aid,print_center,"You have been put to sleep")
	}
	else {//dream eat
		soundcure(id)
		bind_hud(id, 2)
		set_task(1.0, "unsleep", aid)

		new eatdamage = 33

		pokedamage( aid, id, eatdamage, "Dream Eater")
		if(ta==0 || (ta==1 && get_cvar_num("mp_friendlyfire")==1)) Heal(id, eatdamage)

		client_print(id,print_center,"You ate their dream")
		client_print(aid,print_center,"Your dream has been eaten")

		set_task(get_pcvar_float(pm_hauntertime), "bind_status", id )
	}
 }
 ////////////////////
 // Normal Pokemon //
 ////////////////////
 public Chansey_keydown(id)
 {
	if(EggBomb[id]==0){
		give_item(id, "weapon_hegrenade")
		engclient_cmd(id, "weapon_hegrenade")
	}
	else {
		if(EggBomb[id]!=id){
			//stop them from geting a nade immediately
			bind_hud(id, 2)

			soundcast(id)
			set_pev(EggBomb[id], pev_nextthink, 0.1)
			EggBomb[id] = 0
		}
	}
 }
 public chansey_nade(id)
 {
	if(!PMon() || EggBomb[id]==0 || !is_user_alive(id)){
		set_pev(EggBomb[id], pev_nextthink, 0.1)
		bind_hud(id, 2)
		set_task(get_pcvar_float(pm_chantime), "bind_status", id )
	}
	else {
		new Float:timer = entity_get_float(EggBomb[id], EV_FL_nextthink)
		timer += 2.0
		set_pev(EggBomb[id], pev_nextthink, timer)
		set_task(1.0, "chansey_nade", id)
	}
 }
 public chansey_change(parm[])
 {
	new nade = parm[0]

	EggBomb[parm[1]] = nade

	entity_set_model(nade, POKEBALLMDL)
	entity_set_int(nade,EV_INT_solid,1)

	new Float:maxs[3] = {5.0,5.0,5.0}
	new Float:mins[3] = {-5.0,-5.0,-5.0}
	entity_set_size(nade,mins,maxs)

	entity_set_float(nade,EV_FL_scale,0.2)

	chansey_nade(parm[1])
 }
 ///////////////////////////////////////
 //----When someone's ammo changes----//
 //--lots of help from Gorlag/Batman--//
 ///////////////////////////////////////
 public pokemon_ammox(id)
 {
	if ( !PMon() ) return

	new iAmmoType = read_data(1)

	if(iAmmoType == 12 && Pokemon[id]==CHANSEY && EggBomb[id]==0 ){
		new iGrenade = -1
		while ( (iGrenade = find_ent_by_class(iGrenade, "grenade")) > 0 ) {
			if ( id == entity_get_edict(iGrenade, EV_ENT_owner)){
				new parm[2]
				parm[0] = iGrenade
				parm[1] = id
				EggBomb[id] = id
				set_task(0.2, "chansey_change", 0, parm, 2)
			}
		}
	}
 }

 //--Pokemon skills that have to do with being damaged or giving damage--//
 public pokemon_damage(id)
 {
	if (PMon())
	{
		new damage = read_data(2), body, weapon
		new aid = get_user_attacker(id, weapon, body), rand = random_num(1,10)
		new aliveV = is_user_alive(id), aliveA = is_user_alive(aid)


		//skills where the victim has to be alive
		//mainly things that effect only the victim
		if(aliveV){
			//Charmander
			if(Pokemon[id]==CHARMANDER)
			{
				new ragenums

				ragenums = damage / get_pcvar_num(pm_rage)

				rage[id] += ragenums

				client_print(id,print_center,"Your rage is at %d extra damage", rage[id])
			}
			//Geodude
			if(Pokemon[id]==GEODUDE){
				set_user_armor(id, get_user_armor(id) + damage)
			}
		}

		//skills where the attacker has to be alive
		//mainly things that effect only the attacker
		if ( aliveA && aid != id ) {
			//Meowth
			PayDay(aid, damage)

			//Tangela
			if(Pokemon[aid]==TANGELA){
				new tangap = floatround(get_user_armor(id)*get_pcvar_float(pm_tangela))
				if(tangap<damage)
					tangap = damage
				set_user_armor(aid, get_user_armor(aid) + tangap)
				set_user_armor(id, 0)

				soundhit(id)
				soundhit(aid)

				message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
				write_byte(8)		// TE_BEAMENTS
				write_short(id)		// Start Entity
				write_short(aid)	// End Entity
				write_short(rope)	// Sprite Index
				write_byte(1)		// Starting Frame
				write_byte(1)		// Frame Rate in 0.1's
				write_byte(10)		// Life in 0.1's
				write_byte(5)		// Line width in 0.1's
				write_byte(10)		// Noise amplitude in 0.01's
				write_byte(0)		// Red
				write_byte(255)		// Green
				write_byte(200)		// Blue
				write_byte(255)		// Brightness
				write_byte(0)		// Scroll speed in 0.1's
				message_end()
			}
			//Doduo
			if(Pokemon[aid]==DODUO && weapon!=CSW_KNIFE && !aliveV){
				new amount = cs_get_user_bpammo(aid, weapon)
				new mult = 2
				if(amount==0 && weapon==CSW_HEGRENADE){
					give_item(aid, "weapon_hegrenade")
					amount = 1
				}
				cs_set_user_bpammo(aid, weapon, amount*mult)
			}
		}
		//skills where the attacker && victim has to be alive
		//mainly things that effect both, such as extra damage
		if ( aliveV && aliveA && aid != id ) {
			//Charmander
			if (Pokemon[aid]==CHARMANDER && rage[aid] > 0){
				pokedamage( id, aid, rage[aid], "Rage")
				client_print(aid,print_center,"Your rage did %d extra damage", rage[aid])
			}
			//Pikachu
			if(Pokemon[aid]==PIKACHU){
				if(rand<4){
					pokedamage( id, aid, damage, "Quick Attack")
					client_print(aid,print_center,"You did double damage with quick attack")
				}
			}
			//Electrabuzz
			if(Pokemon[aid]==ELECTRABUZZ && weapon!=CSW_KNIFE){
				if(rand<4){
					screenflash(id,255,255,255,255)
					client_print(aid,print_center,"You hit someone with a flash bullet")
					client_print(id,print_center,"You were hit by a flash bullet")
				}
			}
			//Alakazam
			if(Pokemon[id]==ALAKAZAM && weapon!=CSW_KNIFE){
				if(rand<4){
					screenflash(id, 255, 0, 255, 50)
					Heal(id,damage)
					pokedamage( aid, id, damage, "Reflect")
					client_print(aid,print_center,"Someone reflected a bullet")
					client_print(id,print_center,"You reflected a bullet")
				}
			}
			//Caterpie
			if(Pokemon[aid]==CATERPIE && rand<4 && !g_isSlow[id]){
				client_print(id,print_center,"Your speed has decreased")
				client_print(aid,print_center,"Their speed has decreased")

				g_isSlow[id] = true
				SetSpeed(id)
				set_task(get_pcvar_float(pm_stringtime), "unslow", id)

				soundhit(id)
				soundhit(aid)

				message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
				write_byte(8)		// TE_BEAMENTS
				write_short(id)		// Start Entity
				write_short(aid)	// End Entity
				write_short(arbok)	// Sprite Index
				write_byte(1)		// Starting Frame
				write_byte(1)		// Frame Rate in 0.1's
				write_byte(10)		// Life in 0.1's
				write_byte(10)		// Line width in 0.1's
				write_byte(0)		// Noise amplitude in 0.01's
				write_byte(255)		// Red
				write_byte(255)		// Green
				write_byte(255)		// Blue
				write_byte(100)		// Brightness
				write_byte(0)		// Scroll speed in 0.1's
				message_end()
			}
			//Pinsir
			if (Pokemon[aid]==PINSIR && weapon==CSW_KNIFE){
				pokedamage( id, aid, damage, "Slash")
			}
			//Arbok
			if(Pokemon[id]==ARBOK && rand < 4 && cpois[aid]<1){
				new parm[2]
				parm[0] = aid
				parm[1] = id
				cpois[aid] = get_pcvar_num(pm_poisontime)
				client_print(id,print_center,"You poisoned an enemy")
				client_print(aid,print_center,"You have been poisoned")

				message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
				write_byte(8)		// TE_BEAMENTS
				write_short(id)		// Start Entity
				write_short(aid)	// End Entity
				write_short(arbok)		// Sprite Index
				write_byte(1)		// Starting Frame
				write_byte(1)		// Frame Rate in 0.1's
				write_byte(5)		// Life in 0.1's
				write_byte(20)		// Line width in 0.1's
				write_byte(0)		// Noise amplitude in 0.01's
				write_byte(150)		// Red
				write_byte(0)		// Green
				write_byte(150)		// Blue
				write_byte(100)		// Brightness
				write_byte(0)		// Scroll speed in 0.1's
				message_end()

				set_task(0.1, "Poison",0, parm, 2)
			}
		}
	}
 }


 //--This is a loop that is being called every second, some pokemon skills use this--//
 public pokemon_loop()
 {
	new players[MAX_PLAYERS], pnum, id, pid
	get_players(players, pnum, "a")

	for ( new i = 0; i < pnum; i++ )
	{
		id = players[i]
		pid = Pokemon[id]
		if( PMon()){

			if(PokeType(pid, WATER)){
				if(entity_get_int(id, EV_INT_waterlevel) == 3)
					Heal(id,get_pcvar_num(pm_waterheal))
			}
			if(PokeType(pid, GHOST)){
				new max = get_pcvar_num(pm_maxfade), min = get_pcvar_num(pm_minfade), fade
				new mult = (max - min)/9
				if(pid==GASTLY){
					gtime += 1
					if(gtime==20)gtime = 0
					switch(gtime){
						case 0: fade = max
						case 1,19: fade = mult*8 + min
						case 2,18: fade = mult*7 + min
						case 3,17: fade = mult*6 + min
						case 4,16: fade = mult*5 + min
						case 5,15: fade = mult*4 + min
						case 6,14: fade = mult*3 + min
						case 7,13: fade = mult*2 + min
						case 8,9,11,12: fade = mult + min
						case 10: fade = min
					}
				}
				else{
					fade = mult*8 + min
				}
				set_user_rendering(id, kRenderFxGlowShell, 0, 0, 0, kRenderTransAlpha, fade)
				if(fade<33)
					fade = 33
				message_begin(MSG_ONE,gmsgScreenFade,{0,0,0},id)
				write_short( 15 )
				write_short( 15 )
				write_short( 12 )
				write_byte( 0 )
				write_byte( 0 )
				write_byte( 0 )
				write_byte( 255-fade )
				message_end()
			}
			switch(pid){
				case WEEZING:{
					get_user_origin(id, origin[id])
					message_begin(MSG_BROADCAST, SVC_TEMPENTITY) //message begin
					write_byte(17)
					write_coord(origin[id][0]) // start position
					write_coord(origin[id][1])
					write_coord(origin[id][2])
					write_short(gas) // sprite index
					write_byte(10) // scale in 0.1's
					write_byte(50) // brightness
					message_end()

					new aid, playersa[MAX_PLAYERS], pnuma
					get_players(playersa,pnuma,"a")

					for(new ick = 0; ick<pnuma; ick++)
					{
						aid = playersa[ick]
						if( Team(id) != Team(aid) && !cpois[aid]) {
						get_user_origin(aid, origin[aid])

						new distance = get_distance(origin[aid], origin[id])
						new maxdist = 300
						if(distance <= maxdist){
							new parm[2]
							parm[0] = aid
							parm[1] = id
							cpois[aid] = get_pcvar_num(pm_poisontime)
							client_print(id,print_center,"You poisoned an enemy")
							client_print(aid,print_center,"You have been poisoned")

							set_task(0.1, "Poison",0, parm, 2)
							}
						}
					}
				}
				case GENGAR: {
					new rand = random_num(1,8), rand2 = random_num(1,8), numb, numb2

					while(rand!=rand2)
						rand2 = random_num(1,8)

					switch(rand){
						case 1: numb = 1
						case 2: numb = 2
						case 3: numb = 4
						case 4: numb = 8
						case 5: numb = 16
						case 6: numb = 32
						case 7: numb = 64
						case 8: numb = 128
						default: numb = 0
					}
					switch(rand2){
						case 1: numb2 = 1
						case 2: numb2 = 2
						case 3: numb2 = 4
						case 4: numb2 = 8
						case 5: numb2 = 16
						case 6: numb2 = 32
						case 7: numb2 = 64
						case 8: numb2 = 128
						default: numb2 = 0
					}
					set_user_hitzones(0,id,(255-numb)-numb2)
				}
			}
			if(NightVisionUse[id] && !is_user_bot(id)){
				new aid, playersa[MAX_PLAYERS], pnuma
				get_players(playersa,pnuma,"a")

				for(new ick = 0; ick<pnuma; ick++)
				{
					aid = playersa[ick]
					if(80<=Pokemon[aid]<90){ //theyre a ghost so lets play the sprite

						new Float:source[3], Float:target[3], Float:location[3], view[3]
						get_user_origin(id,view,1)

						source[0] = float(view[0])
						source[1] = float(view[1])
						source[2] = float(view[2])
				        
						entity_get_vector(aid,EV_VEC_origin,target)

						if(trace_line(id, source, target, location)==aid){
							new red = 0, blue = 0, green = 0
							get_user_origin(aid, origin[aid])

							switch(Team(aid))
							{
								case 1:{
									red = 255
								}
								case 2:{
									blue = 255
								}
							}

							//Make a line
							message_begin(MSG_ONE, SVC_TEMPENTITY, {0,0,0}, id) 
							write_byte(8)		// TE_BEAMENTS
							write_short(id)		// Start Entity
							write_short(aid)	// End Entity
							write_short(zbeam6)		// Sprite Index
							write_byte(1)		// Starting Frame
							write_byte(1)		// Frame Rate in 0.1's
							write_byte(5)		// Life in 0.1's
							write_byte(10)		// Line width in 0.1's
							write_byte(0)		// Noise amplitude in 0.01's
							write_byte(red)		// Red
							write_byte(green)		// Green
							write_byte(blue)		// Blue
							write_byte(200)		// Brightness
							write_byte(0)		// Scroll speed in 0.1's
							message_end()
						}
					}
				}
			}
			if(is_user_bot(id) && PokeItem(id)){
				new hp = Health(id)
				if(HasPokeItem(id,1) && cpois[id]){
					UseItem(id,1)
				}
				else if(HasPokeItem(id,3) && (cpois[id] || g_isAsleep[id] || g_isLeeched[id] || g_isBurning[id]))
					UseItem(id,3)
				else if(HasPokeItem(id,6) && (cpois[id] || g_isAsleep[id] || g_isLeeched[id] || g_isBurning[id]))
					UseItem(id,6)
				else if(hp<80){
					if(HasPokeItem(id,0))
						UseItem(id,0)
					if(HasPokeItem(id,2) && hp<50)
						UseItem(id,2)
					if(HasPokeItem(id,4) && hp<50)
						UseItem(id,4)
					if(HasPokeItem(id,5) && hp<25)
						UseItem(id,5)
				}
			}
		}
	}
 }

 //--pokemon skills damage--//
 public pokedamage(victim, attacker, damage, Attack[])
 {
	new namek[32],namev[32],authida[35],authidv[35],teama[32],teamv[32], tk
	get_user_name(victim,namev,31)
	get_user_name(attacker,namek,31)
	get_user_authid(victim,authidv,34)
	get_user_authid(attacker,authida,34)
	get_user_team(victim,teamv,31)
	get_user_team(attacker,teama,31)

	if(attacker==victim) tk = 2
	else if(Team(victim) == Team(attacker)) tk = 1
	else tk = 0

	damage *= TypeCheck(attacker, victim)

	if( tk==1 && get_cvar_num("mp_friendlyfire")!=1)
		damage = 0

	if(damage==0) return

	new Float:fl_dmg = float(damage)

	//Meowth
	PayDay(attacker, damage)

	if(damage >= Health(victim))
	{
		set_msg_block(gmsgDeathMsg,BLOCK_SET)

		fakedamage(victim, Attack, fl_dmg, DMG_GENERIC)

		set_msg_block(gmsgDeathMsg,BLOCK_NOT)

		if(is_user_alive(victim))
		return

		message_begin(MSG_ALL, gmsgDeathMsg, {0,0,0}, 0)
		write_byte(attacker)
		write_byte(victim)
		write_byte(0)
		write_string(Attack)
		message_end()

		logKill(attacker, victim, Attack)

		if(tk==1)
		{
			client_print(attacker,print_center,"You killed a teammate")
			set_user_frags(attacker,get_user_frags(attacker) - 1)
			set_user_frags(victim, get_user_frags(victim) + 1)
		}
		else
		{
			new money = cs_get_user_money(attacker)
			cs_set_user_money(attacker, money + 300) // award for kill

			set_user_frags(attacker,get_user_frags(attacker) + 1 )
		}
	}
	else
	{
		logDmg(attacker, victim, Attack,"body",damage,Health(victim)-damage)

		if( tk==1 )
		{
			fakedamage(victim, Attack, fl_dmg, DMG_GENERIC)
			client_print(0,print_chat,"%s attacked a teammate",namek)
		}
		else
		{
			fakedamage(victim, Attack, fl_dmg, DMG_GENERIC)
		}
	}
 }
 // Log a kill using standard HL-logging format
 stock logKill(attacker, victim, weaponDescription[])
 {
	// Save Hummiliation
	new namea[24], namev[24], authida[20], authidv[20], teama[10], teamv[10]

	// Info On Attacker
	get_user_name(attacker, namea, 23)
	get_user_team(attacker, teama, 9)
	get_user_authid(attacker, authida, 19)
	// Info On Victim
	get_user_name(victim, namev, 23)
	get_user_team(victim, teamv, 9)
	get_user_authid(victim, authidv, 19)
	// Log This Kill
	if(attacker==victim){
		log_message("^"%s<%d><%s><%s>^" killed self with ^"%s^"",
		namea, get_user_userid(attacker), authida, teama, namev, get_user_userid(victim), authidv, teamv, weaponDescription)
	}
	else{
		log_message("^"%s<%d><%s><%s>^" killed ^"%s<%d><%s><%s>^" with ^"%s^"",
		namea, get_user_userid(attacker), authida, teama, namev, get_user_userid(victim), authidv, teamv, weaponDescription)
	}
 }
 // Log damage using standard HL-logging format
 stock logDmg(attacker, victim, weaponDescription[],hit[],damage,health)
 {
	if(get_cvar_num("mp_logdetail") != 3) return

	// Save Hummiliation
	new namea[24], namev[24], authida[20], authidv[20], teama[10], teamv[10]

	// Info On Attacker
	get_user_name(attacker, namea, 23)
	get_user_team(attacker, teama, 9)
	get_user_authid(attacker, authida, 19)
	// Info On Victim
	get_user_name(victim, namev, 23)
	get_user_team(victim, teamv, 9)
	get_user_authid(victim, authidv, 19)
	// Log This Damage
	log_message("^"%s<%d><%s><%s>^" attacked ^"%s<%d><%s><%s>^" with ^"%s^" (hit ^"%s^") (damage ^"%d^") (health ^"%d^")",
	namea,get_user_userid(attacker),authida,teama,namev,get_user_userid(victim),authidv,teamv,weaponDescription,hit,damage,health)
 }
 //Does double damage to other pokemon and what not
 TypeCheck(attacker, victim)
 {
	new atype = Pokemon[attacker], vtype = Pokemon[victim]
	new green = 2, orange = 1/2, red = 0, blank = 1

	//Porygons convert into the attackers type
	if(vtype==PORYGON){
		vtype = atype
	}

	//This returns the multiplier for the damage

	if(PokeType(atype, GRASS)){
		if(PokeType(vtype, WATER) || PokeType(vtype, ROCK))
			return green
		if(PokeType(vtype, GRASS) || PokeType(vtype, FIRE) || PokeType(vtype, BUG) || PokeType(vtype, POISON))
			return orange
	}
	if(PokeType(atype, FIRE)){
		if(PokeType(vtype, GRASS) || PokeType(vtype, BUG))
			return green
		if(PokeType(vtype, FIRE) || PokeType(vtype, WATER) || PokeType(vtype, ROCK))
			return orange
	}
	if(PokeType(atype, WATER)){
		if(PokeType(vtype, FIRE) || PokeType(vtype, ROCK))
			return green
		if(PokeType(vtype, GRASS) || PokeType(vtype, WATER))
			return orange
	}
	if(PokeType(atype, ELECTRIC)){
		if(PokeType(vtype, WATER))
			return green
		if(PokeType(vtype, GRASS) || PokeType(vtype, ELECTRIC))
			return orange
	}
	if(PokeType(atype, ROCK)){
		if(PokeType(vtype, FIRE) || PokeType(vtype, BUG))
			return green
	}

	if(PokeType(atype, PSYCHIC)){
		if(PokeType(vtype, POISON)){
			return green
		}
		if(PokeType(vtype, PSYCHIC)){
			return orange
		}
	}
	if(PokeType(atype, BUG)){
		if(PokeType(vtype, GRASS) || PokeType(vtype, PSYCHIC) || PokeType(vtype, POISON)){
			return green
		}
		if(PokeType(vtype, FIRE) || PokeType(vtype, GHOST)){
			return orange
		}
	}
	if(PokeType(atype, POISON)){
		if(PokeType(vtype, GRASS) || PokeType(vtype, BUG)){
			return green
		}
		if(PokeType(vtype, ROCK) || PokeType(vtype, POISON) || PokeType(vtype, GHOST)){
			return orange
		}
	}
	if(PokeType(atype, GHOST)){
		if(PokeType(vtype, GHOST)){
			return green
		}
	}
	if(PokeType(atype, NORMAL)){
		if(PokeType(vtype, ROCK)){
			return orange
		}
		if(PokeType(vtype, GHOST)){
			return red
		}
	}
	return blank
 }

 //--When something touches another--//
 public pfn_touch(ptr, ptd)
 {
	if(!PMon()) return
	if (!is_valid_ent(ptr)) return

	new szClass[32], szClassD[32]
	entity_get_string(ptr, EV_SZ_classname, szClass, 31)
	if(is_valid_ent(ptd))
		entity_get_string(ptd, EV_SZ_classname, szClassD, 31)

	if(is_user_alive(ptr) && is_user_alive(ptd)){
		if(Pokemon[ptd]==ZUBAT){
			new bite = 1

			screenflash(ptd, 255, 0, 0, 150)
			screenflash(ptr, 255, 0, 0, 150)

			pokedamage(ptr, ptd, bite, "Bite")
			Heal(ptd, bite)
		}
	}
	else if(equal(szClass, "npc_pokecenter") && is_user_alive(ptd)){
		PokeMenu(ptd)
	}
	else if(equal(szClass, "boulder"))
	{
		new maxdamage = get_pcvar_num(pm_rockthrow)

		new Float:Velocity[3]
		entity_get_vector(ptr, EV_VEC_velocity, Velocity)

		if(equal(szClassD, "func_breakable") && is_valid_ent(ptd)){
			fakedamage(ptd, "Rock Throw", maxdamage*1.0, DMG_GENERIC)
			if(!is_valid_ent(ptd))
				entity_set_vector(ptr, EV_VEC_velocity, Velocity)
			else
				pfn_touch(ptr, 0)
		}
		else {
			new damradius = 200

			new Float:fl_vExplodeAt[3]
			entity_get_vector(ptr, EV_VEC_origin, fl_vExplodeAt)
			new vExplodeAt[3]
			vExplodeAt[0] = floatround(fl_vExplodeAt[0])
			vExplodeAt[1] = floatround(fl_vExplodeAt[1])
			vExplodeAt[2] = floatround(fl_vExplodeAt[2])
			
			new aid = entity_get_edict(ptr, EV_ENT_owner)
			
			new origin[3],dist,id,Float:dRatio,rockdamage

			new players[MAX_PLAYERS], pnum
			get_players(players,pnum,"a")

			for(new i = 0; i<pnum; i++)
			{
				id = players[i]

				get_user_origin(id,origin)
				dist = get_distance(origin,vExplodeAt)
				if (dist <= damradius)
				{
					dRatio = floatdiv(float(dist),float(damradius))
					rockdamage = maxdamage - floatround(floatmul(float(maxdamage),dRatio))
					pokedamage(id, aid, rockdamage, "Rock Throw")
				}
			}

			message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
			write_byte(17)
			write_coord(vExplodeAt[0])
			write_coord(vExplodeAt[1])
			write_coord(vExplodeAt[2] + 60)
			write_short(xplode)
			write_byte(20)
			write_byte(200)
			message_end()

			emit_sound(ptr, CHAN_WEAPON, "pokemon/a_exm2.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)

			remove_entity(ptr)
		}
	}
	else if(equal(szClass, "psy_beam"))
	{
		new damradius = 200
		new maxdamage = get_pcvar_num(pm_psybeam)

		new Float:fl_vExplodeAt[3]
		entity_get_vector(ptr, EV_VEC_origin, fl_vExplodeAt)
		new vExplodeAt[3]
		vExplodeAt[0] = floatround(fl_vExplodeAt[0])
		vExplodeAt[1] = floatround(fl_vExplodeAt[1])
		vExplodeAt[2] = floatround(fl_vExplodeAt[2])
		
		new aid = entity_get_edict(ptr, EV_ENT_owner)
		
		new origin[3],dist,id,Float:dRatio,damage

		new players[MAX_PLAYERS], pnum
		get_players(players,pnum,"a")

		for(new i = 0; i<pnum; i++)
		{
			id = players[i]

			get_user_origin(id,origin)
			dist = get_distance(origin,vExplodeAt)
			if (dist <= damradius)
			{
				dRatio = floatdiv(float(dist),float(damradius))
				damage = maxdamage - floatround(floatmul(float(maxdamage),dRatio))
				pokedamage(id, aid, damage, "Psy Beam")
			}
		}

		message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
		write_byte(17)
		write_coord(vExplodeAt[0])
		write_coord(vExplodeAt[1])
		write_coord(vExplodeAt[2] + 60)
		write_short(xplode)
		write_byte(20)
		write_byte(200)
		message_end()

		emit_sound(ptr, CHAN_WEAPON, "pokemon/a_exm2.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)

		if(is_user_alive(aid)){
			attach_view(aid, aid)
			set_task(get_pcvar_float(pm_kadatime), "bind_status", aid )
		}
		remove_entity(ptr)
	}
	else if(equali(szClass, "pokeitem") && is_user_alive(ptd))
	{
		new item, TargName[25]

		entity_get_string(ptr, EV_SZ_targetname, TargName, 24)

		item = NameToItem(TargName)

		Give_Item(ptd, item)

		emit_sound(ptd,CHAN_VOICE,"common/bodydrop1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)

		remove_entity(ptr)
	}
	else if(equal(szClass,"grenade") && is_user_alive(ptd))
	{
		new model[40]
		entity_get_string(ptr, EV_SZ_model, model, 39)
		if(equali(model,POKEBALLMDL)){
			if(ptr==EggBomb[ptd]){
				remove_entity(ptr)
				give_item(ptd, "weapon_hegrenade")
				engclient_cmd(ptd, "weapon_hegrenade")
				EggBomb[ptd] = 0
				bind_hud(ptd, 1)
				emit_sound(ptd,CHAN_VOICE,"common/bodydrop1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
			}
			else {
				new id = entity_get_edict(ptr, EV_ENT_owner)
				if(EggBomb[id]!=0)
					Chansey_keydown(id)
			}
		}
	}
 }

 //--Before a client does something--//
 public client_PreThink(id)
 {
	if (!PMon() || !is_user_alive(id)) return

	new nbutton =	entity_get_int(id,EV_INT_button)
	new obutton =	entity_get_int(id,EV_INT_oldbuttons)
	new flag =		entity_get_int(id,EV_INT_flags)
	new clip, ammo, wpnid = get_user_weapon(id, clip, ammo), hp = Health(id)

	switch(Pokemon[id])
	{
		//Pinsir
		case PINSIR:{
			if(nbutton&IN_ATTACK2 && flag&FL_ONGROUND && wpnid==CSW_KNIFE) {

				new aid, body
				get_user_aiming(id, aid, body, 250)
				if(!is_user_alive(aid)){
					new Float:Velocity[3]
					new ammount = 500
					VelocityByAim(id, ammount, Velocity)
					Velocity[2] = float(ammount/2)
					entity_set_vector(id, EV_VEC_velocity, Velocity)
					entity_set_int(id, EV_INT_button, nbutton & ~IN_ATTACK2)
				}
			}
		}
		//Pidgey
		case PIDGEY:{
			if(nbutton&IN_JUMP && !(flag&FL_ONGROUND) && !(obutton&IN_JUMP)) {
				g_canFly[id] = true
			}
		}
		//Snorlax
		case SNORLAX:{
			if(nbutton&IN_DUCK && hp < maxhp[id]){
				new rest = get_pcvar_num(pm_snorlax)
				screenflash(id, 0, 0, 0, 150)
				Heal(id, rest)
			}
		}
	}
 }
 //--After a client does something--//
 public client_PostThink(id)
 {
	if(!is_user_alive(id)) return PLUGIN_CONTINUE

	new nbutton =	entity_get_int(id,EV_INT_button)

	if(g_canFly[id]) {
		new jumpvec = 285
		new push = 50

		new Float:velocity[3]
		entity_get_vector(id,EV_VEC_velocity,velocity)

		new mag = sqroot(floatround((velocity[0]*velocity[0]) + (velocity[1]*velocity[1])))
		if(mag<500 && nbutton&IN_FORWARD){
			new Float:aimvelocity[3]
			VelocityByAim(id, push, aimvelocity)
			velocity[0] += aimvelocity[0]
			velocity[1] += aimvelocity[1]
		}

		if(velocity[2] < 1.5*jumpvec)
			velocity[2] += jumpvec

		entity_set_vector(id,EV_VEC_velocity,velocity)
		entity_set_int(id, EV_INT_gaitsequence, 6)
		g_canFly[id] = false
	}
	return PLUGIN_CONTINUE
 }

 //--Sleeping Things--//
 public hsleep(id)
 {
 	if(g_isAsleep[id]){
		screenflash(id, 0, 0, 0, 255)
		SetSpeed(id)
		set_task(0.1, "hsleep", id)
	}
 }
 public unsleep(id)
 {
	if(g_isAsleep[id]){
		screenflash(id, 0, 0, 0, 0)
		g_isAsleep[id] = false
		SetSpeed(id)
		client_print(id,print_center,"You have woken up")
	}
 }
 public unslow(id)
 {
	if(g_isSlow[id]){
		g_isSlow[id] = false
		SetSpeed(id)
	}
 }
 
 //--Poison--//
 public Poison(parm[])
 {
	new id = parm[1], aid = parm[0]

	if(cpois[aid] > 0 && is_user_alive(aid)){
		cpois[aid] -= 1
		screenflash(aid, 128, 0, 128, 50)
		pokedamage( aid, id, get_pcvar_num(pm_poison), "Poison")
		emit_sound(aid, CHAN_AUTO, "player/pl_pain7.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
		set_task(1.0, "Poison",0, parm, 2)
	}
	else cpois[aid] = 0
 }
 
 //--Switches weapons back--//
 public Scratch(parm[])
 {
	new weaponName[32], id = parm[0]
	screenflash(id, 248, 201, 74, 50)
	screenflash(parm[1], 248, 201, 74, 50)
	get_weaponname(parm[2],weaponName,31)
	engclient_cmd(id, weaponName )
 }

 PassTest(id, num)
 {
	new origin[3], clip, ammo, Float:Orig[3], wpnid = get_user_weapon(id, clip, ammo)
	get_user_origin(id, origin, 3)
	Orig[0]=float(origin[0])
	Orig[1]=float(origin[1])
	Orig[2]=float(origin[2])
	new AimAt = PointContents(Orig)
	if (num > 0 && AimAt == CONTENTS_SKY) {
		client_print(id,print_chat,"%s You cannot do this while aiming at the sky.",PLUGNAME)
		return false
	}
	if(wpnid == CSW_C4){
		client_print(id,print_chat,"%s You cannot do this while holding a c4.",PLUGNAME)
		return false
	}
	return true
 }
 public positionChangeTimer(id)
 {
	if (!is_user_alive(id)) return

	new Float:velocity[3]
	get_user_origin(id, g_lastPosition[id])

	entity_get_vector(id, EV_VEC_velocity, velocity)
	if ( velocity[0]==0.0 && velocity[1]==0.0 ) {
		// Force a Move (small jump)
		velocity[0] += 20.0
		velocity[2] += 50.0
		entity_set_vector(id, EV_VEC_velocity, velocity)
	}

	set_task(0.2,"positionChangeCheck",id)
 }
 public positionChangeCheck(id)
 {
	if (!is_user_alive(id)) return

	new origin[3]
	get_user_origin(id, origin)

	if ( g_lastPosition[id][0] == origin[0] && g_lastPosition[id][1] == origin[1] && g_lastPosition[id][2] == origin[2]) {
		switch(checkCount[id]) {
			case 0 : movecheck(id, 0, 0, 0)	// Original
			case 1 : movecheck(id, 0, 0, 80)	// Up
			case 2 : movecheck(id, 0, 0, -110)	// Down
			case 3 : movecheck(id, 0, 30, 0)	// Forward
			case 4 : movecheck(id, 0, -30, 0)	// Back
			case 5 : movecheck(id, -30, 0, 0)	// Left
			case 6 : movecheck(id, 30, 0, 0)	// Right
			case 7 : movecheck(id, -30, 30, 0)	// Forward-Left
			case 8 : movecheck(id, 30, 30, 0)	// Forward-Right
			case 9 : movecheck(id, -30, -30, 0)	// Back-Left
			case 10: movecheck(id, 30, -30, 0)	// Back-Right
			case 11: movecheck(id, 0, 30, 60)	// Up-Forward
			case 12: movecheck(id, 0, 30, -110)	// Down-Forward
			case 13: movecheck(id, 0, -30, 60)	// Up-Back
			case 14: movecheck(id, 0, -30, -110)	// Down-Back
			case 15: movecheck(id, -30, 0, 60)	// Up-Left
			case 16: movecheck(id, 30, 0, 60)	// Up-Right
			case 17: movecheck(id, -30, 0, -110)	// Down-Left
			case 18: movecheck(id, 30, 0, -110)	// Down-Right
			default: user_kill(id)
		}
		return
	}
 }
 public movecheck(id, mX, mY, mZ)
 {
	new Spot[3]
	Spot[0] = aim[id][0] + mX
	Spot[1] = aim[id][1] + mY
	Spot[2] = aim[id][2] + mZ
	set_user_origin(id,Spot)
	checkCount[id]++
	positionChangeTimer(id)
 }

 //--Resets whether a user can use their pokemon bind--//
 public bind_status(id)
 {
	if(BindUsed[id]){
		if(is_user_alive(id))
			bind_hud(id, 1)
	}
	else bind_hud(id, 0)
 }
 public bind_hud(id, abc)
 {
	if(Pokemon[id]==0) abc = 0
	
	new r,g,b,status

	switch(abc){
		case 1: {
			BindUsed[id] = false

			status = 1
			r = 0
			g = 160
			b = 0
		}
		case 2: {
			BindUsed[id] = true

			status = 1
			r = 160
			g = 0
			b = 0
		}
		default: {
			status = 0
			r = 0
			g = 0
			b = 0
		}
	}

	message_begin( MSG_ONE_UNRELIABLE, gmsgStatusIcon, {0,0,0}, id )
	write_byte( status ) // status
	write_string( "hostage1" ) // sprite name
	write_byte( r ) // red
	write_byte( g ) // green
	write_byte( b ) // blue
	message_end()
 }
 
 //--Finishes the pokecenter heal--//
 public finish_heal(id)
 {
	if(!PMon() || !is_user_alive(id)) return

	new Float:dist, pokedist = get_pcvar_num(pm_pokecenter)

	dist = Float:entity_range(id,PCent[1])
	if(dist>pokedist) dist = Float:entity_range(id,PCent[2])

	if(dist<pokedist){
		client_print(id, print_chat, "Prof. Oak: You are fully healed.")
		set_user_health(id, maxhp[id])
	}
	else {
		client_print(id, print_chat, "Prof. Oak: You are too far away to be healed.")
	}

	ResetStatus(id)
	SetSpeed(id)
 }

 //--Determines what name the pokemon they have is--//
 PokeToName(pid, pokename[25])
 {
	switch(pid){
		case BULBASAUR:			copy(pokename , 25 , "Bulbasaur");
		case BELLSPROUT:		copy(pokename , 25 , "Bellsprout");
		case TANGELA:			copy(pokename , 25 , "Tangela");

		case CHARMANDER:		copy(pokename , 25 , "Charmander");
		case GROWLITHE:			copy(pokename , 25 , "Growlithe");
		case MAGMAR:			copy(pokename , 25 , "Magmar");

		case SQUIRTLE:			copy(pokename , 25 , "Squirtle");
		case STARMIE:			copy(pokename , 25 , "Starmie");
		case POLIWHIRL:			copy(pokename , 25 , "Poliwhirl");

		case PIKACHU:			copy(pokename , 25 , "Pikachu");
		case VOLTORB:			copy(pokename , 25 , "Voltorb");
		case ELECTRABUZZ:		copy(pokename , 25 , "Electrabuzz");

		case GEODUDE:			copy(pokename , 25 , "Geodude");
		case ONIX:				copy(pokename , 25 , "Onix");
		case AERODACTYL:		copy(pokename , 25 , "Aerodactyl");

		case ABRA:				copy(pokename , 25 , "Abra");
		case KADABRA:			copy(pokename , 25 , "Kadabra");
		case ALAKAZAM:			copy(pokename , 25 , "Alakazam");

		case CATERPIE:			copy(pokename , 25 , "Caterpie");
		case VENONAT:			copy(pokename , 25 , "Venonat");
		case PINSIR:			copy(pokename , 25 , "Pinsir");

		case ARBOK:				copy(pokename , 25 , "Arbok");
		case WEEZING:			copy(pokename , 25 , "Weezing");
		case ZUBAT:				copy(pokename , 25 , "Zubat");

		case GASTLY:			copy(pokename , 25 , "Gastly");
		case HAUNTER:			copy(pokename , 25 , "Haunter");
		case GENGAR:			copy(pokename , 25 , "Gengar");

		case PIDGEY:			copy(pokename , 25 , "Pidgey");
		case MEOWTH:			copy(pokename , 25 , "Meowth");
		case CHANSEY:			copy(pokename , 25 , "Chansey");
		case DODUO:				copy(pokename , 25 , "Doduo");
		case PORYGON:			copy(pokename , 25 , "Porygon");
		case SNORLAX:			copy(pokename , 25 , "Snorlax");

		default:				copy(pokename , 25 , "None");
	}
	return pokename
 }
 NameToPoke(const pokename[])
 {
	new pid

	if(equali(pokename, "Bulbasaur"))			pid = BULBASAUR
	else if(equali(pokename, "Bellsprout"))		pid = BELLSPROUT
	else if(equali(pokename, "Tangela"))		pid = TANGELA

	else if(equali(pokename, "Charmander"))		pid = CHARMANDER
	else if(equali(pokename, "Growlithe"))		pid = GROWLITHE
	else if(equali(pokename, "Magmar"))			pid = MAGMAR

	else if(equali(pokename, "Squirtle"))		pid = SQUIRTLE
	else if(equali(pokename, "Starmie"))		pid = STARMIE
	else if(equali(pokename, "Poliwhirl"))		pid = POLIWHIRL

	else if(equali(pokename, "Pikachu"))		pid = PIKACHU
	else if(equali(pokename, "Voltorb"))		pid = VOLTORB
	else if(equali(pokename, "Electrabuzz"))	pid = ELECTRABUZZ

	else if(equali(pokename, "Geodude"))		pid = GEODUDE
	else if(equali(pokename, "Onix"))			pid = ONIX
	else if(equali(pokename, "Aerodactyl"))		pid = AERODACTYL

	else if(equali(pokename, "Abra"))			pid = ABRA
	else if(equali(pokename, "Kadabra"))		pid = KADABRA
	else if(equali(pokename, "Alakazam"))		pid = ALAKAZAM

	else if(equali(pokename, "Caterpie"))		pid = CATERPIE
	else if(equali(pokename, "Venonat"))		pid = VENONAT
	else if(equali(pokename, "Pinsir"))			pid = PINSIR

	else if(equali(pokename, "Arbok"))			pid = ARBOK
	else if(equali(pokename, "Weezing"))		pid = WEEZING
	else if(equali(pokename, "Zubat"))			pid = ZUBAT

	else if(equali(pokename, "Gastly"))			pid = GASTLY
	else if(equali(pokename, "Haunter"))		pid = HAUNTER
	else if(equali(pokename, "Gengar"))			pid = GENGAR

	else if(equali(pokename, "Pidgey"))			pid = PIDGEY
	else if(equali(pokename, "Meowth"))			pid = MEOWTH
	else if(equali(pokename, "Chansey"))		pid = CHANSEY
	else if(equali(pokename, "Doduo"))			pid = DODUO
	else if(equali(pokename, "Porygon"))		pid = PORYGON
	else if(equali(pokename, "Snorlax"))		pid = SNORLAX

	else										pid = 0

	return pid
 }

 //--Determines what name the item they have is--//
 ItemToName(item, itemname[25])
 {
	switch(item){
		case 0:					copy(itemname , 25 , "Potion");
		case 1:					copy(itemname , 25 , "Antidote");
		case 2:					copy(itemname , 25 , "Escape Rope");
		case 3:					copy(itemname , 25 , "Full Heal");
		case 4:					copy(itemname , 25 , "Super Potion");
		case 5:					copy(itemname , 25 , "Hyper Potion");
		case 6:					copy(itemname , 25 , "Full Restore");
		case 7:					copy(itemname , 25 , "Bicycle");
		case 8:					copy(itemname , 25 , "HP Up");
		
		default:				copy(itemname , 25 , "Nothing");
	}
	return itemname
 }
 NameToItem(const itemname[])
 {
	new item

	if(equali(itemname, "Potion"))					item = 0
	else if(equali(itemname, "Antidote"))			item = 1
	else if(equali(itemname, "Escape Rope"))		item = 2
	else if(equali(itemname, "Full Heal"))			item = 3
	else if(equali(itemname, "Super Potion"))		item = 4
	else if(equali(itemname, "Hyper Potion"))		item = 5
	else if(equali(itemname, "Full Restore"))		item = 6
	else if(equali(itemname, "Bicycle"))			item = 7
	else if(equali(itemname, "HP Up"))				item = 8
	else											item = 9

	return item
 }
 
 //--Shows user what they have--//
 public PokeDisplay(id, aid)
 {
	if ( !PMon() || !is_user_connected(id) || !is_user_connected(aid) ) return

	new message[256],pokename[25], iLen

	if(id!=aid){
		new name[129]
		get_user_name(aid,name,128)

		iLen += format(message[iLen],(255-iLen)," %s ", name)
	}
	if(Health(aid) > 255 || maxhp[aid] > 255 || id != aid) iLen += format(message[iLen],(255-iLen)," HP: %d/%d  ", Health(aid), maxhp[aid])

	PokeToName(Pokemon[aid], pokename)

	if(id==aid) iLen += format(message[iLen],(255-iLen),"Pokemon: %s ", pokename )
	else iLen += format(message[iLen],(255-iLen),"%s  ", pokename )

	message_begin( MSG_ONE, gmsgStatusText, {0,0,0}, id)
	write_byte(0)
	write_string(message)
	message_end()
	
	set_task(1.5, "self_display", id)
 }
 //--Displays Personal Info Again--//
 public self_display(id)
 {
	new aid, body
	get_user_aiming(id, aid, body)
	if(!is_user_alive(aid))
		aid = id
	PokeDisplay(id, aid)
 }

 //--Flashes the screen a color--//
 screenflash(id, r, g, b, alpha)
 {
	message_begin(MSG_ONE,gmsgScreenFade,{0,0,0},id)
	write_short( 1<<10 )
	write_short( 1<<10 )
	write_short( 1<<12 )
	write_byte( r )
	write_byte( g )
	write_byte( b )
	write_byte( alpha )
	message_end()
 }
 
 //--Sound when user cant do something--//
 sounddeny(id)
 {
	client_cmd(id,"spk common/wpn_denyselect.wav")
 }
 soundcast(id)
 {
	emit_sound(id, CHAN_WEAPON, "pokemon/cast.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
 }
 soundcure(id)
 {
	emit_sound(id, CHAN_WEAPON, "pokemon/cure.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
 }
 soundhit(id)
 {
	emit_sound(id, CHAN_AUTO, "hornet/ag_hornethit1.wav", VOL_NORM, ATTN_NORM, 0, PITCH_NORM)
 }
 
 //--Finds free place to put escape rope users and npcs--//
 stock find_free_spawn(id, iTeamNumber, Float:spawnOrigin[3], Float:spawnAngle[3])
 {
	new iSpawn
	if(iTeamNumber == 2)
		iSpawn=0
	else
		iSpawn=1

	const maxSpawns = 128
	new spawnPoints[maxSpawns]
	new ent = -1, spawnsFound = 0

	/* Find all of the spawn points */
	do {
		ent = find_ent_by_class(ent,spawnEntString[iSpawn])
		if (ent != 0) {
			spawnPoints[spawnsFound] = ent
			spawnsFound++
		}
	}
	while (ent && spawnsFound < maxSpawns)

	new bool:foundFreeSpawn
	new Float:vicinity = 100.0		//(32x32x96)
	new i, a = 0
	new playersInVicinity
	new entList[1]

	/* Loop through all the spawn points */
	for (i = random_num(0, spawnsFound-1);a < spawnsFound && !foundFreeSpawn;i = random_num(0, spawnsFound-1)) 
	{
		if(spawnPoints[i] != 0 && !spawnPointsused[i])
		{
			a++

			/* Get the origin of the spawn point */
			entity_get_vector(spawnPoints[i],EV_VEC_origin,spawnOrigin)

			/* Determine if a player is in this vicinity */
			playersInVicinity = find_sphere_class(0, "player", vicinity, entList, 1, spawnOrigin)
			playersInVicinity += find_sphere_class(0, "npc_pokecenter", vicinity, entList, 1, spawnOrigin)

			/* If not, we want to transport the player here */
			if (playersInVicinity == 0)
			{
				foundFreeSpawn = true
				spawnPointsused[i] = true
			}
			/* Otherwise we don't */
			else
			{
				foundFreeSpawn = false
			}
		}
		id--
	}

	if( foundFreeSpawn && spawnPoints[i] )
	{
		entity_get_vector(spawnPoints[i], EV_VEC_angles, spawnAngle)
		return spawnPoints[i]
	}

	return -1
 }

 //--Makes NPCs--//
 public npc_pokecenter(team)
 {
	if(is_valid_ent(PCent[team])) return PLUGIN_CONTINUE

	new entSpawn
	new origin[3]
	new Float:spawnAngle[3] 
	new Float:spawnOrigin[3]

	PCent[team] = create_entity("info_target")

	entity_set_string(PCent[team],EV_SZ_classname,"npc_pokecenter");

	entity_set_model(PCent[team],"models/pokemon/oak.mdl");
	entity_set_int(PCent[team],EV_INT_solid, 2)

	new Float:maxs[3] = {16.0,16.0,40.0}
	new Float:mins[3] = {-16.0,-16.0,-40.0}
	entity_set_size(PCent[team],mins,maxs)

	entSpawn = find_free_spawn(PCent[team], team, spawnOrigin, spawnAngle)
		
	if (!entSpawn) 
	{ 
		// Didn't find a free spawn spot. Try again in 5 seconds...
		set_task(5.0,"npc_pokecenter", team)
		return PLUGIN_CONTINUE 
	}
		
	FVecIVec(spawnOrigin, origin)

	spawnOrigin[2] += 10

	entity_set_origin(PCent[team],spawnOrigin);
	
	entity_set_vector(PCent[team], EV_VEC_angles, spawnAngle)

	entity_set_byte(PCent[team],EV_BYTE_controller1,125);
	entity_set_byte(PCent[team],EV_BYTE_controller2,125);
	entity_set_byte(PCent[team],EV_BYTE_controller3,125);
	entity_set_byte(PCent[team],EV_BYTE_controller4,125);

	entity_set_float(PCent[team],EV_FL_animtime,2.0)
	entity_set_float(PCent[team],EV_FL_framerate,1.0)
	entity_set_int(PCent[team],EV_INT_sequence,0);

	entity_set_int(PCent[team], EV_INT_movetype, 6)

	drop_to_floor(PCent[team])
	return 1;
 }
 
 //--Gives items to people that touch dropped items--//
 Give_Item(ptd, item)
 {
	new message[256], itemname[25], amount = 1

	ItemToName(item, itemname)

	format(message,255,"%s You picked up %d %s",PLUGNAME, amount, itemname)

	if(item==7 && HasPokeItem(ptd,7)){//only one bike please
		format(message,255,"%s You found a %s, but it was broken.",PLUGNAME, itemname)
	}
	else
		Item[ptd][item] += amount

	if(item==8)
		maxhp[ptd] += (100*amount)

	client_print(ptd, print_chat, message)
 }

 //--Removes Items--//
 public NoItems(id)
 {
	if(g_isRiding[id]){
		g_isRiding[id] = false
		SetSpeed(id)
	}
	for(new apple = 0; apple<9 ; apple++){
		Item[id][apple] = 0
	}

	return PLUGIN_HANDLED
 }
 /////////////////
 //--Bot Stuff--//
 /////////////////
 BotSay(id, type, num, num2)
 {
	if(get_pcvar_num(pm_botsays)!=1) return

	new tid, players[MAX_PLAYERS], pnum, name[32]
	get_players(players,pnum,"c")
	get_user_name(id,name,31)

	for(new i = 0; i<pnum; i++){

		tid = players[i]

		if(is_user_connected(tid)){
			if(Team(id) == Team(tid)){
				switch(type){
					case 1:{//bought something

						new iname[25]
						ItemToName(num2,iname)
						client_print(tid,print_chat,"%s (RADIO): Bought %d %s.", name, num, iname)

					}
					case 2:{//chose pokemon

						new pname[25]
						PokeToName(num,pname)
						client_print(tid,print_chat,"%s (RADIO): Chose %s.", name, pname)

					}
				}
			}
		}
	}
 }
 BotCenter(id)
 {
	new ran = random_num(1,151)

	if(Pokemon[id]!=0){
		if(ran<75)
			BotMart(id)
	}
	else{
		while(!NonBindPoke(ran))
			ran = random_num(1,151)
		Pokemon[id] = ran
		BotSay(id, 2, ran, 0)
	}
 }
 BotMart(id)
 {
	if(!PokeItem(id)){
		new ran = random_num(0,9)
		ShopChoices(id, ran)
	}
 }
 //--Thing im using so i dont have to use get_user_health each time--//
 Health(id)
 {
	return get_user_health(id)
 }
 //--Thing im using so i dont have to use get_user_team each time--//
 Team(id)
 {
	new CsTeams:team = cs_get_user_team(id)
	switch(team){
		case CS_TEAM_UNASSIGNED:	return 0
		case CS_TEAM_T:				return 1
		case CS_TEAM_CT:			return 2
		case CS_TEAM_SPECTATOR:		return 3
	}
	return 0
 }
 //--Thing im using so i dont have to use set_user_health each time--//
 Heal(id, amm)
 {
	new hp = Health(id)
	if(hp <= maxhp[id] - amm) set_user_health(id, hp + amm)
	else set_user_health(id, maxhp[id])
 }
 debugMessage( message[], id = 0, level = 1 )
 {
	new debugMode = get_pcvar_num(pm_debug)
	new output[256]

	if (debugMode < level && level != 0) return

	if (id > 0 && id <= 33) {
		new name[32],authid[32]
		get_user_name(id,name,31)
		get_user_authid(id,authid,31)
		new userid = get_user_userid(id)
		if ( userid > 0) format(output,255,"^"%s<%d><%s>^" %s", name,userid,authid,message)
	}
	else {
		copy(output,255,message)
	}

	if (strlen(output) <= 0 ) return

	format(output,255,"DEBUG: %s",output)
	log_amx(output)

	return
 }
 stock strbrkqt(const text[], Left[], leftLen, Right[], rightLen)
 {
	//Breaks text[] into two parts, Left[], and Right[]
	// Left[] will contain the first parameter (either quoted or non-quoted)
	// Right[] contain the rest of the string after Left[], not including the space
	new bool:in_quotes = false
	new bool:done_flag = false
	new i, left_pos = 0

	for ( i = 0; i < strlen(text); i++) {

		if (equali(text[i], "^"", 1) && !done_flag) {
			if (in_quotes) {
				done_flag = true
				in_quotes = false
			}
			else in_quotes = true
		}
		else if ( isspace(text[i]) && !in_quotes ) {
			if (left_pos > 0) {
				done_flag = true
			}
		}
		else if (!done_flag && left_pos <= leftLen) {
			setc(Left[left_pos], 1, text[i])
			left_pos++
		}
		else if (done_flag) break
	}

	Left[left_pos] = 0
	copy(Right,rightLen,text[i])

	return true
 }
 //--thing so you can remove ent after time--//
 public poke_remove_entity(ent)
 {
	remove_entity(ent)
 }
 //--Silph Scope / NVG--//
 public event_buynvg(id)
 {
	if(PMon())
		client_print(id, print_chat, "%s You have received a silph scope with your NVG.",PLUGNAME)

	return PLUGIN_CONTINUE
 }
 public SilphScope(id) 
 {
	if ( !PMon() ) return PLUGIN_CONTINUE

	if(cs_get_user_nvg(id)){
		if (NightVisionUse[id])
			NightVisionUse[id] = false
		else
			NightVisionUse[id] = true
	}

	return PLUGIN_CONTINUE
 }
 //--Admin Commands--//
 stock get_info(id,arg1[],name[],namelen)
 {
	new target=cmd_target(id,arg1,15)
	if(!target)
	{
		if(equali(arg1,"@T"))
			target = 111
		else if(equali(arg1,"@CT"))
			target = 222
		else if(equali(arg1,"*"))
			target = 333
		else return 0;
	}
	if(target>MAX_PLAYERS)
		copy(name,namelen,arg1)
	else
		get_user_name(target,name,namelen)
	return target;
 }
 public admin_setpoke(id,level,cid)
 {
	if(!cmd_access(id,level,cid,2))
	{
		return PLUGIN_HANDLED
	}
	new arg1[32], pname[25]
	read_argv(1,arg1,31)
	read_argv(2,pname,24)
	
	new name[32], poke = NameToPoke(pname)
	new target = get_info(id,arg1,name,31)
	if(!target || !poke)
	{
		return PLUGIN_HANDLED
	}
	//fix this so it works with @T @CT and *
	if(target>MAX_PLAYERS){
		console_print(id,"%s %s is not incorperated yet.",PLUGNAME,name)
		return PLUGIN_HANDLED
	}

	new aname[32]
	get_user_name(id,aname,31)

	if(Pokemon[target]==poke)
	{
		console_print(id,"%s %s is already a %s.",PLUGNAME,name,pname)
		return PLUGIN_HANDLED
	}
	
	Pokemon[target] = poke
	console_print(id,"%s %s is now a %s.",PLUGNAME,name,pname)
	client_print(target, print_chat, "%s [Admin]%s has turned you into %s.",PLUGNAME,aname,pname)

	return PLUGIN_HANDLED
 }
 public admin_reset(id)
 {
	if(!( get_user_flags(id)&ADMIN_RCON ))
	{
		client_print( id, print_console, "%s You have no access to that command.",PLUGNAME)
		return PLUGIN_HANDLED
	}

	console_print(id,"%s Files Restored.",PLUGNAME)
	ResetConfig()
	Make_Pokehelp()
	Make_Pokedex()
	Make_Pokedex2()
	client_print(0, print_chat, "%s PokeMod files have been restored to defaults.",PLUGNAME) 

	return PLUGIN_HANDLED
 }
 public admin_loadconfig(id)
 {
	if(!( get_user_flags(id)&ADMIN_BAN ))
	{
		client_print( id, print_console, "%s You have no access to that command.",PLUGNAME)
		return PLUGIN_HANDLED
	}

	console_print(id,"%s Config Files Loaded.",PLUGNAME)
	LoadConfig()
	client_print(0, print_chat, "%s PokeMod config files have been loaded.",PLUGNAME) 

	return PLUGIN_HANDLED
 }

 //--Sets Speed Correctly--//
 public SetSpeed(id)
 {
	//thanks to a plugin i wrote and used
	new Float:speed, clip, ammo, weapon = get_user_weapon(id, clip, ammo)
	switch(weapon)
	{
		case 1,4,6,7,9,10,11,12,16,17,19,23,25,26,29: speed = 250.0
		case 3: speed = 260.0
		case 5,8,14,15: speed = 240.0
		case 13,18,24: speed = 210.0
		case 20: speed = 220.0
		case 21,22: speed = 230.0
		case 27: speed = 235.0
		case 28: speed = 221.0
		case 30: speed = 245.0
	}

	//Pokemon that affect speed
	if(Pokemon[id]==AERODACTYL)
		speed += FASTSPEED/2
	if(Pokemon[id]==SNORLAX)
		speed -= SLOWSPEED

	//Items that affect speed
	if(g_isRiding[id])
		speed += FASTSPEED

	//Statuses that affect speed
	if(g_isSlow[id])
		speed -= SLOWSPEED
	if(g_isStopped[id] || g_isAsleep[id])
		speed = 1.0

	if(is_user_alive(id))
		set_user_maxspeed(id, speed)
 }
 //--When Someone Changes Weapons--//
 public WeaponChange(id)
 {
	SetSpeed(id)
 }
 public NonBindPoke(num)
 {
	switch(num)
	{
		case TANGELA,CHARMANDER,PIKACHU,ELECTRABUZZ,AERODACTYL,ALAKAZAM,CATERPIE,PINSIR,ARBOK,WEEZING,ZUBAT,GASTLY,GENGAR,PIDGEY,MEOWTH,PORYGON,DODUO,SNORLAX: return true
	}
	return false
 }
 public BindPoke(num)
 {
	switch(num)
	{
		case BULBASAUR,BELLSPROUT,GROWLITHE,MAGMAR,SQUIRTLE,STARMIE,POLIWHIRL,VOLTORB,GEODUDE,ONIX,ABRA,KADABRA,VENONAT,HAUNTER,CHANSEY: return true
	}
	return false
 }
 public Make_Pokehelp()
 {
	if(file_exists(g_Pokehelp))
		delete_file(g_Pokehelp)

	write_file(g_Pokehelp,"<center><b><font color=red size=+2>PokeMod</font></b></center>",-1)
	write_file(g_Pokehelp,"<br>",-1)
	write_file(g_Pokehelp,"<center>The World of Pokemon.... in CS!</center>",-1)
	write_file(g_Pokehelp,"<br>",-1)
	write_file(g_Pokehelp,"<li>Touch Prof. Oak for the pokecenter menu(main menu)",-1)
	write_file(g_Pokehelp,"<li>Say /droppoke to change pokemon, or say go pokename (ex. go onix)",-1)
	write_file(g_Pokehelp,"<li>- To see a list of pokemon, say /pokedex or /pokedex2",-1)
	write_file(g_Pokehelp,"<li>You can also bind keys to +pokeskill and +pokeitem",-1)
	write_file(g_Pokehelp,"<li>- To bind a key, follow these steps:",-1)
	write_file(g_Pokehelp,"<li>- 1. Press the ` or ~ key to bring up the console",-1)
	write_file(g_Pokehelp,"<li>- 2. Type bind (key) (what to bind)",-1)
	write_file(g_Pokehelp,"<li>-- For this example you will want to bind +pokeskill or +pokeitem",-1)
	write_file(g_Pokehelp,"<li>- 3. Press enter and voila, now just press (key) and it will do what you binded",-1)
	write_file(g_Pokehelp,"<li>- Examples: bind v +pokeskill, bind f +pokeitem",-1)
	write_file(g_Pokehelp,"<br>",-1)
	write_file(g_Pokehelp,"<br>Check <a href=^"http://www.sha-clan.com^">PokeMod Site</a> for updates, suggestions, and other things.",-1)

 }
 public Make_Pokedex()
 {
	if(file_exists(g_Pokedex))
		delete_file(g_Pokedex)
 
	write_file(g_Pokedex,"<center><b><font color=red size=+2>Pokedex</font></b></center>",-1)
	write_file(g_Pokedex,"<br>",-1)
	write_file(g_Pokedex,"<b>Grass Pokemon</b>",-1)
	write_file(g_Pokedex,"<li>Bulbasaur - Leech Seed* - Drain health from someone into you",-1)
	write_file(g_Pokedex,"<li>Bellsprout - Vine Whip* - Whip players and make them jump",-1)
	write_file(g_Pokedex,"<li>Tangela - Absorb - Steal AP back for damage done to enemies",-1)
	write_file(g_Pokedex,"<br>",-1)
	write_file(g_Pokedex,"<b>Fire Pokemon</b>",-1)
	write_file(g_Pokedex,"<li>Charmander - Rage - Do extra damage after being damaged",-1)
	write_file(g_Pokedex,"<li>Growlithe - Flame Thrower* - Fire a flame thrower and burn your enemies",-1)
	write_file(g_Pokedex,"<li>Magmar - Smokescreen* - Make smoke that blocks players' views",-1)
	write_file(g_Pokedex,"<br>",-1)
	write_file(g_Pokedex,"<b>Water Pokemon</b>",-1)
	write_file(g_Pokedex,"<li>Squirtle - Bubble Beam* - Fire a bubble beam, go into water to recharge",-1)
	write_file(g_Pokedex,"<li>Starmie - Recover* - Receive health for damage that has been done to you",-1)
	write_file(g_Pokedex,"<li>Poliwhirl - Confusion* - Make enemies aim a random direction",-1)
	write_file(g_Pokedex,"<br>",-1)
	write_file(g_Pokedex,"<b>Electric Pokemon</b>",-1)
	write_file(g_Pokedex,"<li>Pikachu - Quick Attack - Chance to do double damage",-1)
	write_file(g_Pokedex,"<li>Voltorb - Self-Destruct - Blow up when you die",-1)
	write_file(g_Pokedex,"<li>Electrabuzz - Flash - Chance to flash an enemy",-1)
	write_file(g_Pokedex,"<br>",-1)
	write_file(g_Pokedex,"<b>Rock Pokemon</b>",-1)
	write_file(g_Pokedex,"<li>Geodude - Harden* - Swap your armor for health",-1)
	write_file(g_Pokedex,"<li>Onix - Rock Throw* - Throw a massive boulder",-1)
	write_file(g_Pokedex,"<li>Aerodactyl - Agility - Run faster",-1)
	write_file(g_Pokedex,"<br>",-1)
	write_file(g_Pokedex,"* - This is a bind skill. Look at /pokehelp for bind help.",-1)
	write_file(g_Pokedex,"<br>",-1)
	write_file(g_Pokedex,"<img src=^"http://img65.imageshack.us/img65/3504/battlechart7nl.gif^">",-1)
	write_file(g_Pokedex,"<li> ^"+^" (green)  does twice the damage",-1)
	write_file(g_Pokedex,"<li> ^"-^" (orange) does half the damage",-1)
	write_file(g_Pokedex,"<li> ^"X^" (red) does no damage",-1)
	write_file(g_Pokedex,"<br>",-1)
	write_file(g_Pokedex," -- To see the other pokemon, say /pokedex2 -- ",-1)

 }
 public Make_Pokedex2()
 {
	if(file_exists(g_Pokedex2))
		delete_file(g_Pokedex2)
 
	write_file(g_Pokedex2,"<center><b><font color=red size=+2>Pokedex</font></b></center>",-1)
	write_file(g_Pokedex2,"<br>",-1)
	write_file(g_Pokedex2,"<b>Psychic Pokemon</b>",-1)
	write_file(g_Pokedex2,"<li>Abra - Teleport* - Teleport to where you're aiming",-1)
	write_file(g_Pokedex2,"<li>Kadabra - Psy Beam* - Fire a very deadly psybeam",-1)
	write_file(g_Pokedex2,"<li>Alakazam - Reflect - Chance of reflecting a bullet back at the enemy",-1)
	write_file(g_Pokedex2,"<br>",-1)
	write_file(g_Pokedex2,"<b>Bug Pokemon</b>",-1)
	write_file(g_Pokedex2,"<li>Caterpie - String Shot - Make enemies slow when you shoot them",-1)
	write_file(g_Pokedex2,"<li>Venonat - Sleeping Powder* - Leave powder that puts enemies to sleep",-1)
	write_file(g_Pokedex2,"<li>Pinsir - Slash - Right-click with knife to lunge forward",-1)
	write_file(g_Pokedex2,"<br>",-1)
	write_file(g_Pokedex2,"<b>Poison Pokemon</b>",-1)
	write_file(g_Pokedex2,"<li>Arbok - Poison Sting - Poison attackers",-1)
	write_file(g_Pokedex2,"<li>Weezing - Toxic - Leave a trail of toxic gas behind you",-1)
	write_file(g_Pokedex2,"<li>Zubat - Bite - Touch players to bite them",-1)
	write_file(g_Pokedex2,"<br>",-1)
	write_file(g_Pokedex2,"<b>Ghost Pokemon</b>",-1)
	write_file(g_Pokedex2,"<li>Gastly - Night Shade - Fade in and out of sight",-1)
	write_file(g_Pokedex2,"<li>Haunter - Hypnosis/Dream Eater - Put people to sleep and eat their dreams",-1)
	write_file(g_Pokedex2,"<li>Gengar - Confuse Ray - Randomly removes 2 of your hitzones",-1)
	write_file(g_Pokedex2,"<br>",-1)
	write_file(g_Pokedex2,"<b>Normal Pokemon</b>",-1)
	write_file(g_Pokedex2,"<li>Pidgey - Fly - Jump in the air to flap your wings",-1)
	write_file(g_Pokedex2,"<li>Meowth - Payday - Get money when a teamate damages someone",-1)
	write_file(g_Pokedex2,"<li>Chansey - Egg Bomb* - Throw pokeballs that you detonate",-1)
	write_file(g_Pokedex2,"<li>Doduo - Double Edge - Kill someone to double your backpack ammo",-1)
	write_file(g_Pokedex2,"<li>Porygon - Conversion - Change to attackers pokemon type",-1)
	write_file(g_Pokedex2,"<li>Snorlax - Rest - Crouch to go to sleep and regain HP",-1)
	write_file(g_Pokedex2,"<br>",-1)
	write_file(g_Pokedex2,"* - This is a bind skill. Look at /pokehelp for bind help.",-1)
	write_file(g_Pokedex2,"<br>",-1)
	write_file(g_Pokedex2,"<img src=^"http://img65.imageshack.us/img65/3504/battlechart7nl.gif^">",-1)
	write_file(g_Pokedex2,"<li> ^"+^" (green)  does twice the damage",-1)
	write_file(g_Pokedex2,"<li> ^"-^" (orange) does half the damage",-1)
	write_file(g_Pokedex2,"<li> ^"X^" (red) does no damage",-1)
	write_file(g_Pokedex2,"<br>",-1)
	write_file(g_Pokedex2," -- To see the other pokemon, say /pokedex -- ",-1)

 }
 //--what type a players poke is--//
 public PokeType(pid, type)
 {
	switch(type)
	{
		case GRASS:{
			switch(pid){
				case BULBASAUR, BELLSPROUT, TANGELA:
					return true
			}
		}
		case FIRE:{
			switch(pid){
				case CHARMANDER, GROWLITHE, MAGMAR:
					return true
			}
		}
		case WATER:{
			switch(pid){
				case SQUIRTLE, STARMIE, POLIWHIRL:
					return true
			}
		}
		case ROCK:{
			switch(pid){
				case GEODUDE, ONIX, AERODACTYL:
					return true
			}
		}
		case ELECTRIC:{
			switch(pid){
				case PIKACHU, VOLTORB, ELECTRABUZZ:
					return true
			}
		}
		case PSYCHIC:{
			switch(pid){
				case ABRA, KADABRA, ALAKAZAM:
					return true
			}
		}
		case BUG:{
			switch(pid){
				case PINSIR, VENONAT, CATERPIE:
					return true
			}
		}
		case POISON:{
			switch(pid){
				case ARBOK, WEEZING, ZUBAT:
					return true
			}
		}
		case GHOST:{
			switch(pid){
				case GASTLY, HAUNTER, GENGAR:
					return true
			}
		}
		case NORMAL:{
			switch(pid){
				case PIDGEY, MEOWTH, CHANSEY, DODUO, PORYGON, SNORLAX:
					return true
			}
		}
	}
	return false
 }
 public CheckMaxHP(id)
 {
	new servermax = get_pcvar_num(pm_maxhp)
	if(maxhp[id] > servermax){
		client_print(id, print_chat, "%s This server's max HP is %d.",PLUGNAME, servermax)
		maxhp[id] = servermax
	}
	if(maxhp[id] <= 100) maxhp[id] = 100
 }
 public PayDay(aid, damage)
 {
	//Meowth
	new players[MAX_PLAYERS], pnum, tid
	get_players(players, pnum, "a")

	for ( new i = 0; i < pnum; i++ )
	{
		tid = players[i]
		if(Team(aid)==Team(tid) && Pokemon[tid]==MEOWTH)
		{
			new extra = damage

			cs_set_user_money(tid, cs_get_user_money(tid)+extra)
		}
	}
 }

 stock get_distance_to_line(Float:pos_start[3], Float:pos_end[3], Float:pos_object[3])  
 {  
	new Float:vec_start_end[3], Float:vec_start_object[3], Float:vec_end_object[3], Float:vec_end_start[3]
	xs_vec_sub(pos_end, pos_start, vec_start_end) 		// vector from start to end 
	xs_vec_sub(pos_object, pos_start, vec_start_object) 	// vector from end to object 
	xs_vec_sub(pos_start, pos_end, vec_end_start) 		// vector from end to start 
	xs_vec_sub(pos_end, pos_object, vec_end_object) 		// vector object to end 

	new Float:len_start_object = getVecLen(vec_start_object) 
	new Float:angle_start = floatacos(xs_vec_dot(vec_start_end, vec_start_object) / (getVecLen(vec_start_end) * len_start_object), degrees)  
	new Float:angle_end = floatacos(xs_vec_dot(vec_end_start, vec_end_object) / (getVecLen(vec_end_start) * getVecLen(vec_end_object)), degrees)  

	if(angle_start <= 90.0 && angle_end <= 90.0) 
		return floatround(len_start_object * floatsin(angle_start, degrees)) 
	return -1  
 }
 stock Float:getVecLen(Float:Vec[3])
 { 
	new Float:VecNull[3] = {0.0, 0.0, 0.0}
	new Float:len = get_distance_f(Vec, VecNull)
	return len
 }
 stock bool:fm_is_ent_visible(index, entity) 
 {
	new Float:origin[3], Float:view_ofs[3], Float:eyespos[3]
	pev(index, pev_origin, origin)
	pev(index, pev_view_ofs, view_ofs)
	xs_vec_add(origin, view_ofs, eyespos)

	new Float:entpos[3]
	pev(entity, pev_origin, entpos)
	engfunc(EngFunc_TraceLine, eyespos, entpos, 0, index)

	switch(pev(entity, pev_solid)) {
		case SOLID_BBOX..SOLID_BSP: return global_get(glb_trace_ent) == entity
	}

	new Float:fraction
	global_get(glb_trace_fraction, fraction)
	if(fraction == 1.0)
		return true

	return false
 }
 
